/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.cookies;

import com.google.inject.Inject;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.spincast.core.cookies.Cookie;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.cookies.CookiesRequestContextAddon;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.server.Server;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.commons.lang3.time.DateUtils;

public class SpincastCookiesRequestContextAddon<R extends RequestContext<?>>
implements CookiesRequestContextAddon<R> {
    private final R requestContext;
    private final Server server;
    private final CookieFactory cookieFactory;
    private Map<String, Cookie> cookies;

    @Inject
    public SpincastCookiesRequestContextAddon(R requestContext, Server server, CookieFactory cookieFactory) {
        this.requestContext = requestContext;
        this.server = server;
        this.cookieFactory = cookieFactory;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected Server getServer() {
        return this.server;
    }

    protected CookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    @Override
    public Cookie getCookie(String name) {
        return this.getCookies().get(name);
    }

    @Override
    public void addCookie(Cookie cookie) {
        boolean valid = this.validateCookie(cookie);
        if (!valid) {
            return;
        }
        this.getCookies().put(cookie.getName(), cookie);
    }

    @Override
    public Cookie createCookie(String name) {
        return this.getCookieFactory().createCookie(name);
    }

    @Override
    public void addCookie(String name, String value) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value);
        this.addCookie(cookie);
    }

    @Override
    public void addCookie(String name, String value, String path, String domain, Date expires, boolean secure, boolean httpOnly, boolean discard, int version) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value, path, domain, expires, secure, httpOnly, discard, version);
        this.addCookie(cookie);
    }

    protected boolean validateCookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "Can't add a NULL cookie");
        String name = cookie.getName();
        if (StringUtils.isBlank(name)) {
            throw new RuntimeException("A cookie can't have an empty name");
        }
        return true;
    }

    @Override
    public void deleteCookie(String name) {
        Cookie cookie = this.getCookies().get(name);
        this.deleteCookie(cookie);
    }

    @Override
    public void deleteAllCookies() {
        for (Cookie cookie : this.getCookies().values()) {
            this.deleteCookie(cookie);
        }
    }

    protected void deleteCookie(Cookie cookie) {
        if (cookie != null) {
            cookie.setExpires(DateUtils.addYears(new Date(), -1));
        }
    }

    @Override
    public Map<String, Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = this.getServer().getCookies(this.getRequestContext().exchange());
        }
        return this.cookies;
    }

    @Override
    public void resetCookies() {
        this.cookies = null;
    }

    @Override
    public boolean isCookiesEnabledValidated() {
        return this.getCookies().size() > 0;
    }
}

