/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.undertow.ClosedEventSentCallback;
import org.spincast.plugins.undertow.UndertowWebsocketEndpointWriter;
import org.spincast.plugins.undertow.WebsocketPeersWriteCallback;
import org.spincast.plugins.undertow.config.SpincastUndertowConfig;

public class SpincastUndertowWebsocketEndpointWriter
implements UndertowWebsocketEndpointWriter {
    protected final Logger logger = LoggerFactory.getLogger(SpincastUndertowWebsocketEndpointWriter.class);
    private final SpincastUndertowConfig spincastUndertowConfig;
    private final Map<String, WebSocketChannel> channels;
    private byte[] pingBytes;

    @AssistedInject
    public SpincastUndertowWebsocketEndpointWriter(@Assisted Map<String, WebSocketChannel> channels, SpincastUndertowConfig spincastUndertowConfig) {
        this.channels = channels;
        this.spincastUndertowConfig = spincastUndertowConfig;
    }

    protected Map<String, WebSocketChannel> getChannelsMap() {
        return this.channels;
    }

    protected SpincastUndertowConfig getSpincastUndertowConfig() {
        return this.spincastUndertowConfig;
    }

    protected byte[] getPingBytes() {
        if (this.pingBytes == null) {
            try {
                this.pingBytes = this.getSpincastUndertowConfig().getWebsocketPingMessageString().getBytes("UTF-8");
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        return this.pingBytes;
    }

    @Override
    public void sendPings(final WebsocketPeersWriteCallback callback) {
        this.write(this.getChannelsMap().keySet(), new IWriteExecutor(){

            @Override
            public void write(WebSocketChannel channel, WebSocketCallback<Void> writeCallback) {
                WebSockets.sendPing(ByteBuffer.wrap(SpincastUndertowWebsocketEndpointWriter.this.getPingBytes()), channel, writeCallback);
            }

            @Override
            public void writeErrors(Set<String> peerIds) {
                callback.connectionClosed(peerIds);
            }
        });
    }

    @Override
    public void sendMessage(Set<String> peerIds, final String message, final WebsocketPeersWriteCallback callback) {
        this.write(peerIds, new IWriteExecutor(){

            @Override
            public void write(WebSocketChannel channel, WebSocketCallback<Void> writeCallback) {
                WebSockets.sendText(message, channel, writeCallback);
            }

            @Override
            public void writeErrors(Set<String> peerIds) {
                callback.connectionClosed(peerIds);
            }
        });
    }

    @Override
    public void sendMessage(Set<String> peerIds, final byte[] bytes, final WebsocketPeersWriteCallback callback) {
        this.write(peerIds, new IWriteExecutor(){

            @Override
            public void write(WebSocketChannel channel, WebSocketCallback<Void> writeCallback) {
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                WebSockets.sendBinary(buffer, channel, writeCallback);
            }

            @Override
            public void writeErrors(Set<String> peerIds) {
                callback.connectionClosed(peerIds);
            }
        });
    }

    @Override
    public void sendClosingConnection(final int closingCode, final String closingReason, Set<String> peerIds, final ClosedEventSentCallback callback) {
        if (peerIds == null || peerIds.size() == 0) {
            callback.done();
            return;
        }
        try {
            this.write(peerIds, new IWriteExecutor(){

                @Override
                public void write(WebSocketChannel channel, WebSocketCallback<Void> writeCallback) {
                    WebSockets.sendClose(closingCode, closingReason, channel, writeCallback);
                }

                @Override
                public void writeErrors(Set<String> peerIds) {
                    if (peerIds != null && peerIds.size() > 0) {
                        SpincastUndertowWebsocketEndpointWriter.this.logger.debug("Error sending 'Closed' messages to " + peerIds.size() + " peers.");
                    }
                    callback.done();
                }
            });
        }
        catch (Exception ex) {
            this.logger.error("Exception trying to send 'Closed' messages to peers : " + ex.getMessage());
            callback.done();
            return;
        }
    }

    public void write(Set<String> peerIds, final IWriteExecutor executor) {
        if (peerIds == null || peerIds.size() == 0) {
            executor.writeErrors(new HashSet<String>());
            return;
        }
        Map<String, WebSocketChannel> channelsMap = this.getChannelsMap();
        final HashSet<String> peerIdsRemaining = new HashSet<String>(peerIds);
        final HashSet<String> peerIdsWriteErrors = new HashSet<String>();
        for (final String peerId : peerIds) {
            WebSocketChannel channel = channelsMap.get(peerId);
            if (channel == null) {
                peerIdsRemaining.remove(peerId);
                if (peerIdsRemaining.size() != 0) continue;
                executor.writeErrors(peerIdsWriteErrors);
                return;
            }
            try {
                executor.write(channel, new WebSocketCallback<Void>(){

                    @Override
                    public void onError(WebSocketChannel channel, Void context, Throwable throwable) {
                        if (throwable instanceof IOException || !channel.isOpen()) {
                            peerIdsWriteErrors.add(peerId);
                        } else {
                            SpincastUndertowWebsocketEndpointWriter.this.logger.error("An exception which is not a IOException occured while trying to write to a Websocket peer: " + throwable);
                        }
                        peerIdsRemaining.remove(peerId);
                        if (peerIdsRemaining.size() == 0) {
                            executor.writeErrors(peerIdsWriteErrors);
                        }
                    }

                    @Override
                    public void complete(WebSocketChannel channel, Void context) {
                        peerIdsRemaining.remove(peerId);
                        if (peerIdsRemaining.size() == 0) {
                            executor.writeErrors(peerIdsWriteErrors);
                        }
                    }
                });
            }
            catch (Exception ex) {
                this.logger.debug("Unable to send 'closing Websocket connection' to peer '" + peerId + "' : " + ex.getMessage());
                peerIdsRemaining.remove(peerId);
                if (peerIdsRemaining.size() != 0) continue;
                executor.writeErrors(peerIdsWriteErrors);
                return;
            }
        }
    }

    protected static interface IWriteExecutor {
        public void write(WebSocketChannel var1, WebSocketCallback<Void> var2);

        public void writeErrors(Set<String> var1);
    }
}

