/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart.controller;

import com.google.inject.Inject;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.exceptions.NotFoundException;
import org.spincast.core.exceptions.PublicException;
import org.spincast.core.exceptions.PublicExceptionDefault;
import org.spincast.core.json.JsonObject;
import org.spincast.quickstart.config.AppConfig;
import org.spincast.quickstart.exchange.AppRequestContext;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class AppController {
    protected final Logger logger = LoggerFactory.getLogger(AppController.class);
    private final AppConfig appConfig;

    @Inject
    public AppController(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    protected AppConfig getAppConfig() {
        return this.appConfig;
    }

    protected void addCommonModelElements(AppRequestContext context) {
        context.response().getModel().put("appName", this.getAppConfig().getAppName());
        context.response().getModel().put("serverPort", this.getAppConfig().getHttpServerPort());
    }

    public void index(AppRequestContext context) {
        this.addCommonModelElements(context);
        context.response().sendTemplateHtml("/templates/index.html");
    }

    public void movieInfo(AppRequestContext context) {
        JsonObject movieInfo = null;
        String movieName = context.request().getQueryStringParamFirst("name");
        if (!StringUtils.isBlank(movieName)) {
            try {
                String url = "https://www.omdbapi.com/?t=" + URLEncoder.encode(movieName, "UTF-8") + "&y=&plot=short&r=json";
                movieInfo = context.httpClient().GET(url).send().getContentAsJsonObject();
                boolean responseOk = movieInfo.getBoolean("Response", false);
                if (!responseOk) {
                    throw new NotFoundException("This movie was not found!");
                }
                String poster = movieInfo.getString("Poster", null);
                if (StringUtils.isBlank(poster) || !poster.startsWith("http://") && !poster.startsWith("https://")) {
                    movieInfo.put("Poster", "/public/images/noPoster.jpg");
                }
                if (!movieInfo.isCanBeConvertedToDouble("imdbRating")) {
                    movieInfo.put("imdbRating", "");
                }
            }
            catch (NotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage());
                throw new PublicExceptionDefault("Unable to get the movie information... Maybe omdbapi.com's is down or you don't have Internet connection?");
            }
        }
        context.response().getModel().put("movieInfo", movieInfo);
        context.response().getModel().put("movieName", movieName);
        this.addCommonModelElements(context);
        context.response().sendTemplateHtml("/templates/movie.html");
    }

    public void exceptionExample(AppRequestContext context) {
        throw new RuntimeException("This simulates an exception in the application!");
    }

    public void notFound(AppRequestContext context) {
        String notFoundMessage = "Page not found";
        String specificNotFoundMessage = context.variables().getAsString(SpincastConstants.RequestScopedVariables.NOT_FOUND_PUBLIC_MESSAGE);
        if (specificNotFoundMessage != null) {
            notFoundMessage = specificNotFoundMessage;
        }
        if (context.request().isJsonShouldBeReturn()) {
            JsonObject errorObj = context.json().create();
            errorObj.put("message", notFoundMessage);
            context.response().sendJson(errorObj);
        } else {
            context.response().getModel().put("notFoundMessage", notFoundMessage);
            this.addCommonModelElements(context);
            context.response().sendTemplateHtml("/templates/notFound.html");
        }
    }

    public void exception(AppRequestContext context) {
        String errorMessage = "An error occured! Please try again later...";
        Throwable originalException = context.variables().get(SpincastConstants.RequestScopedVariables.EXCEPTION, Throwable.class);
        this.logger.error("An exception occured : " + originalException);
        if (originalException != null && originalException instanceof PublicException) {
            errorMessage = originalException.getMessage();
        }
        if (context.request().isJsonShouldBeReturn()) {
            JsonObject errorObj = context.json().create();
            errorObj.put("error", errorMessage);
            context.response().sendJson(errorObj);
        } else {
            context.response().getModel().put("errorMessage", errorMessage);
            this.addCommonModelElements(context);
            context.response().sendTemplateHtml("/templates/exception.html");
        }
    }
}

