/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.AbstractRenderableNode;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import com.mitchellbosecke.pebble.template.ScopeChain;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ForNode
extends AbstractRenderableNode {
    private final String variableName;
    private final Expression<?> iterableExpression;
    private final BodyNode body;
    private final BodyNode elseBody;

    public ForNode(int lineNumber, String variableName, Expression<?> iterableExpression, BodyNode body, BodyNode elseBody) {
        super(lineNumber);
        this.variableName = variableName;
        this.iterableExpression = iterableExpression;
        this.body = body;
        this.elseBody = elseBody;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContext context) throws PebbleException, IOException {
        Object iterableEvaluation = this.iterableExpression.evaluate(self, context);
        Iterable<Object> iterable = null;
        if (iterableEvaluation == null) {
            return;
        }
        iterable = this.toIterable(iterableEvaluation);
        if (iterable == null) {
            throw new PebbleException(null, "Not an iterable object. Value = [" + iterableEvaluation.toString() + "]", this.getLineNumber(), self.getName());
        }
        Iterator<Object> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            boolean usingExecutorService;
            ScopeChain scopeChain = context.getScopeChain();
            scopeChain.pushScope();
            int length = this.getIteratorSize(iterableEvaluation);
            int index = 0;
            HashMap<String, Comparable<Boolean>> loop = null;
            boolean bl = usingExecutorService = context.getExecutorService() != null;
            while (iterator.hasNext()) {
                if (index == 0 || usingExecutorService) {
                    loop = new HashMap<String, Comparable<Boolean>>();
                    loop.put("first", Boolean.valueOf(index == 0));
                    loop.put("last", Boolean.valueOf(index == length - 1));
                    loop.put("length", Integer.valueOf(length));
                } else {
                    if (index == 1) {
                        loop.put("first", Boolean.valueOf(false));
                    }
                    if (index == length - 1) {
                        loop.put("last", Boolean.valueOf(true));
                    }
                }
                loop.put("revindex", Integer.valueOf(length - index - 1));
                loop.put("index", Integer.valueOf(index++));
                scopeChain.put("loop", loop);
                scopeChain.put(this.variableName, iterator.next());
                this.body.render(self, writer, context);
            }
            scopeChain.popScope();
        } else if (this.elseBody != null) {
            this.elseBody.render(self, writer, context);
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public String getIterationVariable() {
        return this.variableName;
    }

    public Expression<?> getIterable() {
        return this.iterableExpression;
    }

    public BodyNode getBody() {
        return this.body;
    }

    public BodyNode getElseBody() {
        return this.elseBody;
    }

    private Iterable<Object> toIterable(final Object obj) {
        Iterable<Object> result = null;
        if (obj instanceof Iterable) {
            result = (Set)obj;
        } else if (obj instanceof Map) {
            result = ((Map)obj).entrySet();
        } else if (obj.getClass().isArray()) {
            if (Array.getLength(obj) == 0) {
                return new ArrayList<Object>(0);
            }
            result = new Iterable<Object>(){

                @Override
                public Iterator<Object> iterator() {
                    return new Iterator<Object>(){
                        private int index = 0;
                        private final int length;
                        {
                            this.length = Array.getLength(obj);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.index < this.length;
                        }

                        @Override
                        public Object next() {
                            return Array.get(obj, this.index++);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        return result;
    }

    private int getIteratorSize(Object iterable) {
        if (iterable == null) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        if (iterable instanceof Map) {
            return ((Map)iterable).size();
        }
        if (iterable.getClass().isArray()) {
            return Array.getLength(iterable);
        }
        Iterator it = ((Iterable)iterable).iterator();
        int size = 0;
        while (it.hasNext()) {
            ++size;
            it.next();
        }
        return size;
    }
}

