/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class SubstringMap<V> {
    private static final int ALL_BUT_LAST_BIT = -2;
    private volatile Object[] table = new Object[16];
    private int size;

    public SubstringMatch<V> get(String key, int length) {
        return this.get(key, length, false);
    }

    public SubstringMatch<V> get(String key) {
        return this.get(key, key.length(), false);
    }

    private SubstringMatch<V> get(String key, int length, boolean exact) {
        int pos;
        if (key.length() < length) {
            throw new IllegalArgumentException();
        }
        Object[] table = this.table;
        int hash = SubstringMap.hash(key, length);
        int start = pos = this.tablePos(table, hash);
        while (table[pos] != null) {
            if (exact ? table[pos].equals(key) : this.doEquals((String)table[pos], key, length)) {
                return (SubstringMatch)table[pos + 1];
            }
            if ((pos += 2) >= table.length) {
                pos = 0;
            }
            if (pos != start) continue;
            return null;
        }
        return null;
    }

    private int tablePos(Object[] table, int hash) {
        return hash & table.length - 1 & 0xFFFFFFFE;
    }

    private boolean doEquals(String s1, String s2, int length) {
        if (s1.length() != length || s2.length() < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public synchronized void put(String key, V value) {
        Object[] newTable;
        if (key == null) {
            throw new NullPointerException();
        }
        if ((double)this.table.length / (double)this.size < 4.0 && this.table.length != Integer.MAX_VALUE) {
            newTable = new Object[this.table.length << 1];
            for (int i = 0; i < this.table.length; i += 2) {
                if (this.table[i] == null) continue;
                this.doPut(newTable, (String)this.table[i], this.table[i + 1]);
            }
        } else {
            newTable = new Object[this.table.length];
            System.arraycopy(this.table, 0, newTable, 0, this.table.length);
        }
        this.doPut(newTable, key, new SubstringMatch<V>(key, value));
        this.table = newTable;
        ++this.size;
    }

    public synchronized V remove(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object value = null;
        Object[] newTable = new Object[this.table.length];
        for (int i = 0; i < this.table.length; i += 2) {
            if (this.table[i] != null && !this.table[i].equals(key)) {
                this.doPut(newTable, (String)this.table[i], this.table[i + 1]);
                continue;
            }
            if (this.table[i] == null) continue;
            value = this.table[i + 1];
            --this.size;
        }
        this.table = newTable;
        if (value == null) {
            return null;
        }
        return ((SubstringMatch)value).getValue();
    }

    private void doPut(Object[] newTable, String key, Object value) {
        int hash = SubstringMap.hash(key, key.length());
        int pos = this.tablePos(newTable, hash);
        while (newTable[pos] != null && !newTable[pos].equals(key)) {
            if ((pos += 2) < newTable.length) continue;
            pos = 0;
        }
        newTable[pos] = key;
        newTable[pos + 1] = value;
    }

    public Map<String, V> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object[] t = this.table;
        for (int i = 0; i < t.length; i += 2) {
            if (t[i] == null) continue;
            map.put((String)t[i], ((SubstringMatch)t[i + 1]).value);
        }
        return map;
    }

    public synchronized void clear() {
        this.size = 0;
        this.table = new Object[16];
    }

    private static int hash(String value, int length) {
        if (length == 0) {
            return 0;
        }
        int h2 = 0;
        for (int i = 0; i < length; ++i) {
            h2 = 31 * h2 + value.charAt(i);
        }
        return h2;
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                int i;
                final Object[] tMap = SubstringMap.this.table;
                for (i = 0; i < SubstringMap.this.table.length && tMap[i] == null; i += 2) {
                }
                final int startPos = i;
                return new Iterator<String>(){
                    private Object[] map;
                    private int pos;
                    {
                        this.map = tMap;
                        this.pos = startPos;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pos < SubstringMap.this.table.length;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        String ret = (String)this.map[this.pos];
                        this.pos += 2;
                        while (this.pos < SubstringMap.this.table.length && tMap[this.pos] == null) {
                            this.pos += 2;
                        }
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static final class SubstringMatch<V> {
        private final String key;
        private final V value;

        public SubstringMatch(String key, V value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

