/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.routing.hotlinking;

import com.google.inject.Inject;
import java.net.URI;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.routing.StaticResource;
import org.spincast.core.routing.hotlinking.HotlinkingManager;
import org.spincast.core.routing.hotlinking.HotlinkingStategy;
import org.spincast.core.utils.SpincastStatics;

public class HotlinkingManagerDefault
implements HotlinkingManager {
    private final SpincastConfig spincastConfig;

    @Inject
    public HotlinkingManagerDefault(SpincastConfig spincastConfig) {
        this.spincastConfig = spincastConfig;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    @Override
    public HotlinkingStategy getHotlinkingStategy(Object serverExchange, URI resourceURI, StaticResource<?> resource) {
        return HotlinkingStategy.FORBIDDEN;
    }

    @Override
    public String getRedirectUrl(Object serverExchange, URI resourceURI, StaticResource<?> resource) {
        return null;
    }

    @Override
    public boolean mustHotlinkingProtect(Object serverExchange, URI resourceUri, String requestOriginHeader, String requestRefererHeader, StaticResource<?> resource) {
        return resource.isHotlinkingProtected() && !this.isHostAndRefererValid(serverExchange, resourceUri, requestOriginHeader, requestRefererHeader, resource);
    }

    protected boolean isHostAndRefererValid(Object serverExchange, URI resourceUri, String requestOriginHeader, String requestRefererHeader, StaticResource<?> resource) {
        try {
            String requiredHost = this.getSpincastConfig().getPublicServerHost();
            if (requestOriginHeader == null && requestRefererHeader == null) {
                return true;
            }
            if (requestOriginHeader != null && requiredHost.equalsIgnoreCase(new URI(requestOriginHeader).getHost())) {
                return true;
            }
            return requestRefererHeader != null && requiredHost.equalsIgnoreCase(new URI(requestRefererHeader).getHost());
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }
}

