/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.websocket;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.server.Server;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.websocket.WebsocketContextFactory;
import org.spincast.core.websocket.WebsocketController;
import org.spincast.core.websocket.WebsocketEndpointHandler;
import org.spincast.core.websocket.WebsocketEndpointManager;
import org.spincast.core.websocket.WebsocketPeerManager;

public class WebsocketEndpointHandlerDefault<R extends RequestContext<?>, W extends WebsocketContext<?>>
implements WebsocketEndpointHandler {
    protected static final Logger logger = LoggerFactory.getLogger(WebsocketEndpointHandlerDefault.class);
    private final Server server;
    private final String endpointId;
    private final WebsocketController<R, W> controller;
    private WebsocketEndpointManager endpointManager;
    private final WebsocketContextFactory<W> websocketContextFactory;
    private final Map<String, W> peerContextesMap = new HashMap<String, W>();

    @AssistedInject
    public WebsocketEndpointHandlerDefault(@Assisted(value="endpointId") String endpointId, @Assisted WebsocketController<R, W> controller, WebsocketContextFactory<W> websocketContextFactory, Server server) {
        this.endpointId = endpointId;
        this.controller = controller;
        this.websocketContextFactory = websocketContextFactory;
        this.server = server;
    }

    protected String getEndpointId() {
        return this.endpointId;
    }

    protected WebsocketController<R, W> getController() {
        return this.controller;
    }

    protected Server getServer() {
        return this.server;
    }

    protected WebsocketEndpointManager getEndpointManager() {
        if (this.endpointManager == null) {
            this.endpointManager = this.getServer().getWebsocketEndpointManager(this.getEndpointId());
        }
        return this.endpointManager;
    }

    protected WebsocketContextFactory<W> getWebsocketContextFactory() {
        return this.websocketContextFactory;
    }

    protected Map<String, W> getPeerContextesMap() {
        return this.peerContextesMap;
    }

    protected W getWebsocketPeerContext(String peerId) {
        WebsocketContext peerContext = (WebsocketContext)this.getPeerContextesMap().get(peerId);
        if (peerContext == null) {
            if (this.getEndpointManager() == null) {
                throw new RuntimeException("The endpoint manager is null, we can't create a Websocket context.");
            }
            WebsocketPeerManager peerWriter = this.createWebsocketPeerManager(peerId);
            peerContext = this.getWebsocketContextFactory().create(this.getEndpointId(), peerId, peerWriter);
            this.getPeerContextesMap().put(peerId, peerContext);
        }
        return (W)peerContext;
    }

    @Override
    public void onPeerConnected(String peerId) {
        this.getController().onPeerConnected(this.getWebsocketPeerContext(peerId));
    }

    @Override
    public void onPeerMessage(String peerId, String message) {
        if (this.getEndpointManager() == null) {
            logger.error("The Websocket manager is null! Skipping message from peer '" + peerId + "': " + message);
            return;
        }
        this.getController().onPeerMessage(this.getWebsocketPeerContext(peerId), message);
    }

    @Override
    public void onPeerMessage(String peerId, byte[] message) {
        if (this.getEndpointManager() == null) {
            logger.error("The Websocket manager is null! Skipping bytes message from peer '" + peerId);
            return;
        }
        this.getController().onPeerMessage(this.getWebsocketPeerContext(peerId), message);
    }

    @Override
    public void onEndpointClosed() {
        this.getController().onEndpointClosed(this.getEndpointId());
    }

    @Override
    public void onPeerClosed(String peerId) {
        try {
            this.getController().onPeerClosed(this.getWebsocketPeerContext(peerId));
        }
        finally {
            this.getPeerContextesMap().remove(peerId);
        }
    }

    protected WebsocketPeerManager createWebsocketPeerManager(final String peerId) {
        final WebsocketEndpointManager endpointManager = this.getEndpointManager();
        return new WebsocketPeerManager(){

            @Override
            public void sendMessage(String message) {
                endpointManager.sendMessage(peerId, message);
            }

            @Override
            public void sendMessage(byte[] bytes) {
                endpointManager.sendMessage(peerId, bytes);
            }

            @Override
            public void closeConnection() {
                try {
                    endpointManager.closePeer(peerId);
                }
                finally {
                    WebsocketEndpointHandlerDefault.this.getPeerContextesMap().remove(peerId);
                }
            }
        };
    }
}

