/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart.config;

import com.google.inject.Inject;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.utils.ResourceInfo;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.logbackutils.config.SpincastLogbackConfigurerConfigDefault;
import org.spincast.quickstart.config.AppConfig;

public class AppLogbackConfigurerConfig
extends SpincastLogbackConfigurerConfigDefault {
    private final AppConfig appConfig;
    private final TemplatingEngine templatingEngine;

    @Inject
    public AppLogbackConfigurerConfig(SpincastUtils spincastUtils, AppConfig appConfig, TemplatingEngine templatingEngine) {
        super(spincastUtils);
        this.appConfig = appConfig;
        this.templatingEngine = templatingEngine;
    }

    protected AppConfig getAppConfig() {
        return this.appConfig;
    }

    protected TemplatingEngine getTemplatingEngine() {
        return this.templatingEngine;
    }

    @Override
    public ResourceInfo getResourceInfo() {
        return new ResourceInfo("/quick-start/logback-config.xml", true);
    }

    @Override
    public String tweakContent(String logbackContent) {
        String appRootPackage = this.getAppConfig().getAppRootPackage();
        String defaultLevel = this.getAppConfig().isDevelopmentMode() ? "warn" : "error";
        String appLevel = this.getAppConfig().isDevelopmentMode() ? "debug" : "warn";
        String logbackContentTweaked = this.getTemplatingEngine().evaluate(logbackContent, SpincastStatics.params("APP_ROOT_PACKAGE", appRootPackage, "DEFAULT_LEVEL", defaultLevel, "APP_LEVEL", appLevel));
        return logbackContentTweaked;
    }
}

