/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Connection;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio._private.Messages;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.http.ExtendedHandshakeChecker;
import org.xnio.http.HandshakeChecker;
import org.xnio.http.HttpUpgradeParser;
import org.xnio.http.RedirectException;
import org.xnio.http.UpgradeFailedException;
import org.xnio.ssl.SslConnection;
import org.xnio.ssl.XnioSsl;

public class HttpUpgrade {
    public static IoFuture<SslConnection> performUpgrade(XnioWorker worker, XnioSsl ssl, InetSocketAddress bindAddress, URI uri, Map<String, String> headers, ChannelListener<? super SslConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap, HandshakeChecker handshakeChecker) {
        return new HttpUpgradeState(worker, ssl, bindAddress, uri, headers, openListener, bindListener, optionMap, handshakeChecker).doUpgrade();
    }

    public static IoFuture<SslConnection> performUpgrade(XnioWorker worker, XnioSsl ssl, InetSocketAddress bindAddress, URI uri, Map<String, List<String>> headers, ChannelListener<? super SslConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap, ExtendedHandshakeChecker handshakeChecker) {
        return new HttpUpgradeState(worker, ssl, bindAddress, uri, headers, openListener, bindListener, optionMap, handshakeChecker).doUpgrade();
    }

    public static IoFuture<StreamConnection> performUpgrade(XnioWorker worker, InetSocketAddress bindAddress, URI uri, Map<String, String> headers, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap, HandshakeChecker handshakeChecker) {
        return new HttpUpgradeState(worker, null, bindAddress, uri, headers, openListener, bindListener, optionMap, handshakeChecker).doUpgrade();
    }

    public static IoFuture<StreamConnection> performUpgrade(XnioWorker worker, InetSocketAddress bindAddress, URI uri, Map<String, List<String>> headers, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap, ExtendedHandshakeChecker handshakeChecker) {
        return new HttpUpgradeState(worker, null, bindAddress, uri, headers, openListener, bindListener, optionMap, handshakeChecker).doUpgrade();
    }

    public static <T extends StreamConnection> IoFuture<T> performUpgrade(T connection, URI uri, Map<String, String> headers, ChannelListener<? super StreamConnection> openListener, HandshakeChecker handshakeChecker) {
        return new HttpUpgradeState<T>(connection, uri, headers, openListener, handshakeChecker).upgradeExistingConnection();
    }

    public static <T extends StreamConnection> IoFuture<T> performUpgrade(T connection, URI uri, Map<String, List<String>> headers, ChannelListener<? super StreamConnection> openListener, ExtendedHandshakeChecker handshakeChecker) {
        return new HttpUpgradeState<T>(connection, uri, headers, openListener, handshakeChecker).upgradeExistingConnection();
    }

    private HttpUpgrade() {
    }

    private static class HttpUpgradeState<T extends StreamConnection> {
        private final XnioWorker worker;
        private final XnioSsl ssl;
        private final InetSocketAddress bindAddress;
        private final URI uri;
        private final Map<String, List<String>> headers;
        private final ChannelListener<? super T> openListener;
        private final ChannelListener<? super BoundChannel> bindListener;
        private final OptionMap optionMap;
        private final Object handshakeChecker;
        private final FutureResult<T> future = new FutureResult();
        private T connection;

        private HttpUpgradeState(XnioWorker worker, XnioSsl ssl, InetSocketAddress bindAddress, URI uri, Map<String, String> headers, ChannelListener<? super T> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap, HandshakeChecker handshakeChecker) {
            this.worker = worker;
            this.ssl = ssl;
            this.bindAddress = bindAddress;
            this.uri = uri;
            this.openListener = openListener;
            this.bindListener = bindListener;
            this.optionMap = optionMap;
            this.handshakeChecker = handshakeChecker;
            HashMap<String, List<String>> newHeaders = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                newHeaders.put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
            this.headers = newHeaders;
        }

        private HttpUpgradeState(XnioWorker worker, XnioSsl ssl, InetSocketAddress bindAddress, URI uri, Map<String, List<String>> headers, ChannelListener<? super T> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap, ExtendedHandshakeChecker handshakeChecker) {
            this.worker = worker;
            this.ssl = ssl;
            this.bindAddress = bindAddress;
            this.uri = uri;
            this.headers = headers;
            this.openListener = openListener;
            this.bindListener = bindListener;
            this.optionMap = optionMap;
            this.handshakeChecker = handshakeChecker;
        }

        public HttpUpgradeState(T connection, URI uri, Map<String, String> headers, ChannelListener<? super StreamConnection> openListener, HandshakeChecker handshakeChecker) {
            this.worker = ((Connection)connection).getWorker();
            this.ssl = null;
            this.bindAddress = null;
            this.uri = uri;
            this.openListener = openListener;
            this.bindListener = null;
            this.optionMap = OptionMap.EMPTY;
            this.handshakeChecker = handshakeChecker;
            this.connection = connection;
            HashMap<String, List<String>> newHeaders = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                newHeaders.put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
            this.headers = newHeaders;
        }

        public HttpUpgradeState(T connection, URI uri, Map<String, List<String>> headers, ChannelListener<? super StreamConnection> openListener, ExtendedHandshakeChecker handshakeChecker) {
            this.worker = ((Connection)connection).getWorker();
            this.ssl = null;
            this.bindAddress = null;
            this.uri = uri;
            this.headers = headers;
            this.openListener = openListener;
            this.bindListener = null;
            this.optionMap = OptionMap.EMPTY;
            this.handshakeChecker = handshakeChecker;
            this.connection = connection;
        }

        private IoFuture<T> doUpgrade() {
            InetSocketAddress address = new InetSocketAddress(this.uri.getHost(), this.uri.getPort());
            ConnectionOpenListener connectListener = new ConnectionOpenListener();
            String scheme = this.uri.getScheme();
            if (scheme.equals("http")) {
                if (this.bindAddress == null) {
                    this.worker.openStreamConnection(address, connectListener, this.bindListener, this.optionMap).addNotifier(new FailureNotifier(), null);
                } else {
                    this.worker.openStreamConnection(this.bindAddress, address, connectListener, this.bindListener, this.optionMap).addNotifier(new FailureNotifier(), null);
                }
            } else if (scheme.equals("https")) {
                if (this.ssl == null) {
                    throw Messages.msg.missingSslProvider();
                }
                if (this.bindAddress == null) {
                    this.ssl.openSslConnection(this.worker, address, (ChannelListener<? super SslConnection>)connectListener, this.bindListener, this.optionMap).addNotifier(new FailureNotifier(), null);
                } else {
                    this.ssl.openSslConnection(this.worker, this.bindAddress, address, (ChannelListener<? super SslConnection>)connectListener, this.bindListener, this.optionMap).addNotifier(new FailureNotifier(), null);
                }
            } else {
                throw Messages.msg.invalidURLScheme(scheme);
            }
            return this.future.getIoFuture();
        }

        private String buildHttpRequest() {
            StringBuilder builder = new StringBuilder();
            builder.append("GET ");
            builder.append(this.uri.getPath().isEmpty() ? "/" : this.uri.getPath());
            if (this.uri.getQuery() != null && !this.uri.getQuery().isEmpty()) {
                builder.append('?');
                builder.append(this.uri.getQuery());
            }
            builder.append(" HTTP/1.1\r\n");
            HashSet<String> seen = new HashSet<String>();
            for (Map.Entry<String, List<String>> headerEntry : this.headers.entrySet()) {
                for (String value : headerEntry.getValue()) {
                    builder.append(headerEntry.getKey());
                    builder.append(": ");
                    builder.append(value);
                    builder.append("\r\n");
                    seen.add(headerEntry.getKey().toLowerCase(Locale.ENGLISH));
                }
            }
            if (!seen.contains("host")) {
                builder.append("Host: ");
                builder.append(this.getHost());
                builder.append("\r\n");
            }
            if (!seen.contains("connection")) {
                builder.append("Connection: upgrade\r\n");
            }
            if (!seen.contains("upgrade")) {
                throw new IllegalArgumentException("Upgrade: header was not supplied in header arguments");
            }
            builder.append("\r\n");
            return builder.toString();
        }

        private String getHost() {
            String scheme = this.uri.getScheme();
            int port = this.uri.getPort();
            if (port < 0 || "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443) {
                return this.uri.getHost();
            }
            return this.uri.getHost() + ":" + port;
        }

        public IoFuture<T> upgradeExistingConnection() {
            ConnectionOpenListener connectListener = new ConnectionOpenListener();
            connectListener.handleEvent(this.connection);
            return this.future.getIoFuture();
        }

        private void flushUpgradeChannel() {
            try {
                if (!((StreamConnection)this.connection).getSinkChannel().flush()) {
                    ((StreamConnection)this.connection).getSinkChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            channel.suspendWrites();
                            new UpgradeResultListener().handleEvent(HttpUpgradeState.this.connection.getSourceChannel());
                        }
                    }, new ChannelExceptionHandler<StreamSinkChannel>(){

                        @Override
                        public void handleException(StreamSinkChannel channel, IOException exception) {
                            IoUtils.safeClose((Closeable)channel);
                            HttpUpgradeState.this.future.setException(exception);
                        }
                    }));
                    ((StreamConnection)this.connection).getSinkChannel().resumeWrites();
                    return;
                }
            }
            catch (IOException e) {
                IoUtils.safeClose(this.connection);
                this.future.setException(e);
                return;
            }
            new UpgradeResultListener().handleEvent(((StreamConnection)this.connection).getSourceChannel());
        }

        private void handleUpgrade(HttpUpgradeParser parser) {
            HashMap<String, String> simpleHeaders = new HashMap<String, String>();
            for (Map.Entry<String, List<String>> e : parser.getHeaders().entrySet()) {
                simpleHeaders.put(e.getKey(), e.getValue().get(0));
            }
            String contentLength = (String)simpleHeaders.get("content-length");
            if (contentLength != null && !"0".equals(contentLength)) {
                this.future.setException(new IOException("Upgrade responses must have a content length of zero."));
                return;
            }
            String transferCoding = (String)simpleHeaders.get("transfer-encoding");
            if (transferCoding != null) {
                this.future.setException(new IOException("Upgrade responses cannot have a transfer coding"));
                return;
            }
            if (this.handshakeChecker != null) {
                try {
                    if (this.handshakeChecker instanceof ExtendedHandshakeChecker) {
                        ((ExtendedHandshakeChecker)this.handshakeChecker).checkHandshakeExtended(parser.getHeaders());
                    } else {
                        ((HandshakeChecker)this.handshakeChecker).checkHandshake(simpleHeaders);
                    }
                }
                catch (IOException e) {
                    IoUtils.safeClose(this.connection);
                    this.future.setException(e);
                    return;
                }
            }
            this.future.setResult(this.connection);
            ChannelListeners.invokeChannelListener(this.connection, this.openListener);
        }

        private void handleRedirect(HttpUpgradeParser parser) {
            List<String> location = parser.getHeaders().get("location");
            this.future.setException(new RedirectException(Messages.msg.redirect(), parser.getResponseCode(), location == null ? null : location.get(0)));
        }

        private class FailureNotifier
        extends IoFuture.HandlingNotifier<StreamConnection, Object> {
            private FailureNotifier() {
            }

            @Override
            public void handleFailed(IOException exception, Object attachment) {
                HttpUpgradeState.this.future.setException(exception);
            }

            @Override
            public void handleCancelled(Object attachment) {
                HttpUpgradeState.this.future.setCancelled();
            }
        }

        private final class UpgradeResultListener
        implements ChannelListener<StreamSourceChannel> {
            private final HttpUpgradeParser parser = new HttpUpgradeParser();
            private ByteBuffer buffer = ByteBuffer.allocate(1024);

            private UpgradeResultListener() {
            }

            @Override
            public void handleEvent(StreamSourceChannel channel) {
                do {
                    try {
                        int r = channel.read(this.buffer);
                        if (r == 0) {
                            channel.getReadSetter().set(this);
                            channel.resumeReads();
                            return;
                        }
                        if (r == -1) {
                            throw Messages.msg.connectionClosedEarly();
                        }
                        this.buffer.flip();
                        this.parser.parse(this.buffer);
                        if (this.parser.isComplete()) continue;
                        this.buffer.compact();
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)channel);
                        HttpUpgradeState.this.future.setException(e);
                        return;
                    }
                } while (!this.parser.isComplete());
                channel.suspendReads();
                if (this.buffer.hasRemaining()) {
                    StreamSourceConduit orig = HttpUpgradeState.this.connection.getSourceChannel().getConduit();
                    PushBackStreamSourceConduit pushBack = new PushBackStreamSourceConduit(orig);
                    pushBack.pushBack(new Pooled<ByteBuffer>(){

                        @Override
                        public void discard() {
                            UpgradeResultListener.this.buffer = null;
                        }

                        @Override
                        public void free() {
                            UpgradeResultListener.this.buffer = null;
                        }

                        @Override
                        public ByteBuffer getResource() throws IllegalStateException {
                            return UpgradeResultListener.this.buffer;
                        }

                        @Override
                        public void close() {
                            this.free();
                        }
                    });
                    HttpUpgradeState.this.connection.getSourceChannel().setConduit(pushBack);
                }
                if (this.parser.getResponseCode() == 101) {
                    HttpUpgradeState.this.handleUpgrade(this.parser);
                } else if (this.parser.getResponseCode() == 301 || this.parser.getResponseCode() == 302 || this.parser.getResponseCode() == 303 || this.parser.getResponseCode() == 307 || this.parser.getResponseCode() == 308) {
                    IoUtils.safeClose((Closeable)HttpUpgradeState.this.connection);
                    HttpUpgradeState.this.handleRedirect(this.parser);
                } else {
                    IoUtils.safeClose((Closeable)HttpUpgradeState.this.connection);
                    HttpUpgradeState.this.future.setException(new UpgradeFailedException("Invalid response code " + this.parser.getResponseCode()));
                }
            }
        }

        private final class StringWriteListener
        implements ChannelListener<StreamSinkChannel> {
            final ByteBuffer buffer;

            private StringWriteListener(ByteBuffer buffer) {
                this.buffer = buffer;
            }

            @Override
            public void handleEvent(StreamSinkChannel channel) {
                do {
                    try {
                        int r = channel.write(this.buffer);
                        if (r == 0) {
                            return;
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)channel);
                        HttpUpgradeState.this.future.setException(e);
                        return;
                    }
                } while (this.buffer.hasRemaining());
                channel.suspendWrites();
                HttpUpgradeState.this.flushUpgradeChannel();
            }
        }

        private class ConnectionOpenListener
        implements ChannelListener<StreamConnection> {
            private ConnectionOpenListener() {
            }

            @Override
            public void handleEvent(StreamConnection channel) {
                HttpUpgradeState.this.connection = channel;
                ByteBuffer buffer = ByteBuffer.wrap(HttpUpgradeState.this.buildHttpRequest().getBytes());
                do {
                    try {
                        int r = channel.getSinkChannel().write(buffer);
                        if (r == 0) {
                            channel.getSinkChannel().getWriteSetter().set(new StringWriteListener(buffer));
                            channel.getSinkChannel().resumeWrites();
                            return;
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose((Closeable)channel);
                        HttpUpgradeState.this.future.setException(e);
                        return;
                    }
                } while (buffer.hasRemaining());
                HttpUpgradeState.this.flushUpgradeChannel();
            }
        }
    }
}

