/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.builder;

import groovy.lang.MetaProperty;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.regex.Pattern;
import org.spockframework.builder.CollectionSlot;
import org.spockframework.builder.ISlot;
import org.spockframework.builder.ISlotFactory;
import org.spockframework.util.GroovyRuntimeUtil;
import org.spockframework.util.MopUtil;

public class CollectionSlotFactory
implements ISlotFactory {
    private static final Pattern pluralIESPattern = Pattern.compile(".*[^aeiouy]y", 2);

    public ISlot create(Object object, Type type, String string) {
        String string2 = this.toPluralForm(string);
        MetaProperty metaProperty = GroovyRuntimeUtil.getMetaClass(object).getMetaProperty(string2);
        return metaProperty != null && Collection.class.isAssignableFrom(metaProperty.getType()) && MopUtil.isReadable(metaProperty) ? new CollectionSlot(string2, object, type, metaProperty) : null;
    }

    private String toPluralForm(String string) {
        if (string.toLowerCase().endsWith("s")) {
            return string + "es";
        }
        boolean bl = pluralIESPattern.matcher(string).matches();
        return bl ? string.substring(0, string.length() - 1) + "ies" : string + "s";
    }
}

