/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.buildsupport;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.spockframework.buildsupport.SpecClassFileVisitor;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.ReflectionUtil;

class AsmClassReader {
    private static final Method acceptMethod;
    private static final Object acceptMethodSecondArg;
    private final ClassReader reader;

    AsmClassReader(InputStream inputStream) throws IOException {
        this.reader = new ClassReader(inputStream);
    }

    void accept(SpecClassFileVisitor specClassFileVisitor) {
        ReflectionUtil.invokeMethod(this.reader, acceptMethod, specClassFileVisitor, acceptMethodSecondArg);
    }

    static {
        Method method = ReflectionUtil.getMethodBySignature(ClassReader.class, "accept", ClassVisitor.class, Boolean.TYPE);
        Comparable<Boolean> comparable = true;
        if (method == null) {
            method = ReflectionUtil.getMethodBySignature(ClassReader.class, "accept", ClassVisitor.class, Integer.TYPE);
            comparable = 7;
        }
        if (method == null) {
            throw new InternalSpockError("failed to find method org.objectweb.asm.ClassReader.accept(); seems like an incompatible version of ASM is on the class path");
        }
        acceptMethod = method;
        acceptMethodSecondArg = comparable;
    }
}

