/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.buildsupport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spockframework.buildsupport.AsmClassReader;
import org.spockframework.buildsupport.SpecClassFileVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecClassFileFinder {
    public List<File> findRunnableSpecs(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new FileNotFoundException(String.format("directory %s not found", file));
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        this.doFindRunnableSpecs(file, arrayList);
        Collections.sort(arrayList);
        return arrayList;
    }

    private void doFindRunnableSpecs(File file, List<File> list) throws IOException {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                this.doFindRunnableSpecs(file2, list);
                continue;
            }
            if (!this.isRunnableSpec(file2)) continue;
            list.add(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunnableSpec(File file) throws IOException {
        if (!file.getName().endsWith(".class") || !file.isFile()) {
            return false;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            SpecClassFileVisitor specClassFileVisitor = new SpecClassFileVisitor();
            AsmClassReader asmClassReader = new AsmClassReader(bufferedInputStream);
            asmClassReader.accept(specClassFileVisitor);
            boolean bl = specClassFileVisitor.isRunnableSpec();
            return bl;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }
}

