/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.lang.Wildcard;
import org.spockframework.util.InternalSpockError;
import spock.lang.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstUtil {
    public static boolean hasAnnotation(ASTNode aSTNode, Class<?> clazz) {
        return AstUtil.getAnnotation(aSTNode, clazz) != null;
    }

    public static AnnotationNode getAnnotation(ASTNode aSTNode, Class<?> clazz) {
        if (!(aSTNode instanceof AnnotatedNode)) {
            return null;
        }
        AnnotatedNode annotatedNode = (AnnotatedNode)aSTNode;
        List list = annotatedNode.getAnnotations();
        for (AnnotationNode annotationNode : list) {
            if (!annotationNode.getClassNode().getName().equals(clazz.getName())) continue;
            return annotationNode;
        }
        return null;
    }

    public static List<Statement> getStatements(MethodNode methodNode) {
        Statement statement = methodNode.getCode();
        if (!(statement instanceof BlockStatement)) {
            BlockStatement blockStatement = new BlockStatement();
            if (statement != null) {
                blockStatement.addStatement(statement);
            }
            methodNode.setCode((Statement)blockStatement);
        }
        return ((BlockStatement)methodNode.getCode()).getStatements();
    }

    public static List<Statement> getStatements(ClosureExpression closureExpression) {
        BlockStatement blockStatement = (BlockStatement)closureExpression.getCode();
        return blockStatement == null ? Collections.emptyList() : blockStatement.getStatements();
    }

    public static boolean isMethodInvocation(Expression expression) {
        return expression instanceof MethodCallExpression || expression instanceof StaticMethodCallExpression;
    }

    public static Expression getInvocationTarget(Expression expression) {
        if (expression instanceof PropertyExpression) {
            return ((PropertyExpression)expression).getObjectExpression();
        }
        if (expression instanceof MethodCallExpression) {
            return ((MethodCallExpression)expression).getObjectExpression();
        }
        if (expression instanceof StaticMethodCallExpression) {
            return new ClassExpression(((StaticMethodCallExpression)expression).getOwnerType());
        }
        return null;
    }

    public static boolean isWildcardRef(Expression expression) {
        VariableExpression variableExpression = AstUtil.asInstance(expression, VariableExpression.class);
        if (variableExpression == null || !variableExpression.getName().equals(Wildcard.INSTANCE.toString())) {
            return false;
        }
        Variable variable = variableExpression.getAccessedVariable();
        if (variable instanceof FieldNode) {
            return ((FieldNode)variable).getOwner().getName().equals(Specification.class.getName());
        }
        return variable instanceof DynamicVariable;
    }

    public static boolean isJavaIdentifier(String string) {
        if (string == null || string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends Expression> T getExpression(Statement statement, Class<T> clazz) {
        ExpressionStatement expressionStatement = AstUtil.asInstance(statement, ExpressionStatement.class);
        if (expressionStatement == null) {
            return null;
        }
        return (T)((Expression)AstUtil.asInstance(expressionStatement.getExpression(), clazz));
    }

    public static <T> T asInstance(Object object, Class<T> clazz) {
        return (T)(clazz.isInstance(object) ? object : null);
    }

    public static boolean isSynthetic(MethodNode methodNode) {
        return methodNode.isSynthetic() || (methodNode.getModifiers() & 0x1000) != 0;
    }

    public static boolean hasPlausibleSourcePosition(ASTNode aSTNode) {
        return aSTNode.getLineNumber() > 0 && aSTNode.getLastLineNumber() >= aSTNode.getLineNumber() && aSTNode.getColumnNumber() > 0 && aSTNode.getLastColumnNumber() > aSTNode.getColumnNumber();
    }

    public static List<Expression> getArguments(Expression expression) {
        if (expression instanceof MethodCallExpression) {
            return AstUtil.getArguments((MethodCallExpression)expression);
        }
        if (expression instanceof StaticMethodCallExpression) {
            return AstUtil.getArguments((StaticMethodCallExpression)expression);
        }
        return null;
    }

    public static List<Expression> getArguments(MethodCallExpression methodCallExpression) {
        if (methodCallExpression.getArguments() instanceof NamedArgumentListExpression) {
            return Collections.singletonList(methodCallExpression.getArguments());
        }
        return ((TupleExpression)methodCallExpression.getArguments()).getExpressions();
    }

    public static List<Expression> getArguments(StaticMethodCallExpression staticMethodCallExpression) {
        if (staticMethodCallExpression.getArguments() instanceof NamedArgumentListExpression) {
            return Collections.singletonList(staticMethodCallExpression.getArguments());
        }
        return ((TupleExpression)staticMethodCallExpression.getArguments()).getExpressions();
    }

    public static Expression toArgumentArray(List<Expression> list, IRewriteResources iRewriteResources) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        ArrayList<ConstantExpression> arrayList3 = new ArrayList<ConstantExpression>();
        for (int i = 0; i < list.size(); ++i) {
            Expression expression = list.get(i);
            if (expression instanceof SpreadExpression) {
                arrayList2.add(((SpreadExpression)expression).getExpression());
                arrayList3.add(new ConstantExpression((Object)i));
                continue;
            }
            arrayList.add(expression);
        }
        if (arrayList2.isEmpty()) {
            return new ArrayExpression(ClassHelper.OBJECT_TYPE, list);
        }
        return new MethodCallExpression((Expression)new ClassExpression(iRewriteResources.getAstNodeCache().SpockRuntime), (Expression)new ConstantExpression((Object)"despreadList"), (Expression)new ArgumentListExpression((Expression)new ArrayExpression(ClassHelper.OBJECT_TYPE, arrayList), (Expression)new ArrayExpression(ClassHelper.OBJECT_TYPE, arrayList2), (Expression)new ArrayExpression(ClassHelper.int_TYPE, arrayList3)));
    }

    public static boolean isBuiltinMemberAssignmentOrCall(Expression expression, String string, int n, int n2) {
        return expression instanceof BinaryExpression && AstUtil.isBuiltinMemberAssignment((BinaryExpression)expression, string, n, n2) || expression instanceof MethodCallExpression && AstUtil.isBuiltinMemberCall((MethodCallExpression)expression, string, n, n2);
    }

    public static boolean isBuiltinMemberAssignment(BinaryExpression binaryExpression, String string, int n, int n2) {
        return binaryExpression.getOperation().getType() == 100 && AstUtil.isBuiltinMemberAssignmentOrCall(binaryExpression.getRightExpression(), string, n, n2);
    }

    public static boolean isBuiltinMemberCall(Expression expression, String string, int n, int n2) {
        return expression instanceof MethodCallExpression && AstUtil.isBuiltinMemberCall((MethodCallExpression)expression, string, n, n2);
    }

    public static boolean isBuiltinMemberCall(MethodCallExpression methodCallExpression, String string, int n, int n2) {
        return (AstUtil.isThisExpression(methodCallExpression.getObjectExpression()) || AstUtil.isSuperExpression(methodCallExpression.getObjectExpression())) && string.equals(methodCallExpression.getMethodAsString()) && AstUtil.getArguments(methodCallExpression).size() >= n && AstUtil.getArguments(methodCallExpression).size() <= n2;
    }

    public static void expandBuiltinMemberAssignmentOrCall(Expression expression, Expression ... expressionArray) throws InvalidSpecCompileException {
        if (expression instanceof BinaryExpression) {
            AstUtil.expandBuiltinMemberAssignment((BinaryExpression)expression, expressionArray);
        } else {
            AstUtil.expandBuiltinMemberCall(expression, expressionArray);
        }
    }

    public static void expandBuiltinMemberAssignment(BinaryExpression binaryExpression, Expression ... expressionArray) throws InvalidSpecCompileException {
        Expression expression = binaryExpression.getRightExpression();
        String string = AstUtil.getInferredName(binaryExpression);
        Expression expression2 = AstUtil.getType(expression, (Expression)AstUtil.getInferredType(binaryExpression));
        AstUtil.doExpandBuiltinMemberCall(expression, string, expression2, expressionArray);
    }

    public static void expandBuiltinMemberCall(Expression expression, Expression ... expressionArray) throws InvalidSpecCompileException {
        AstUtil.doExpandBuiltinMemberCall(expression, null, AstUtil.getType(expression, null), expressionArray);
    }

    private static Expression getType(Expression expression, Expression expression2) throws InvalidSpecCompileException {
        List<Expression> list = AstUtil.getArguments(expression);
        assert (list != null);
        if (list.isEmpty()) {
            if (expression2 == null) {
                throw new InvalidSpecCompileException((ASTNode)expression, "Type cannot be inferred; please specify one explicitely", new Object[0]);
            }
            return expression2;
        }
        return list.get(0);
    }

    private static String getInferredName(BinaryExpression binaryExpression) {
        Expression expression = binaryExpression.getLeftExpression();
        if (expression instanceof Variable) {
            return ((Variable)expression).getName();
        }
        if (expression instanceof FieldExpression) {
            return ((FieldExpression)expression).getFieldName();
        }
        return null;
    }

    private static ClassExpression getInferredType(BinaryExpression binaryExpression) {
        ClassNode classNode = binaryExpression.getLeftExpression().getType();
        return classNode == null || classNode == ClassHelper.DYNAMIC_TYPE ? null : new ClassExpression(classNode);
    }

    private static void doExpandBuiltinMemberCall(Expression expression, String string, Expression expression2, Expression ... expressionArray) {
        AstUtil.checkIsSafeToMutateArgs(expression);
        List<Expression> list = AstUtil.getArguments(expression);
        list.clear();
        list.add(expression2);
        list.add((Expression)new ConstantExpression((Object)string));
        list.addAll(Arrays.asList(expressionArray));
    }

    private static void checkIsSafeToMutateArgs(Expression expression) {
        Expression expression2 = ((MethodCallExpression)expression).getArguments();
        if (expression2 == ArgumentListExpression.EMPTY_ARGUMENTS) {
            throw new InternalSpockError("checkIsSafeToMutateArgs");
        }
    }

    public static Expression getAssertionMessage(AssertStatement assertStatement) {
        Expression expression = assertStatement.getMessageExpression();
        if (expression == null) {
            return null;
        }
        if (!(expression instanceof ConstantExpression)) {
            return expression;
        }
        return ((ConstantExpression)expression).isNullExpression() ? null : expression;
    }

    public static boolean isThisExpression(Expression expression) {
        return expression instanceof VariableExpression && ((VariableExpression)expression).isThisExpression();
    }

    public static boolean isSuperExpression(Expression expression) {
        return expression instanceof VariableExpression && ((VariableExpression)expression).isSuperExpression();
    }

    public static void setVisibility(MethodNode methodNode, int n) {
        int n2 = methodNode.getModifiers();
        methodNode.setModifiers((n2 &= 0xFFFFFFF8) | n);
    }

    public static int getVisibility(FieldNode fieldNode) {
        return fieldNode.getModifiers() & 7;
    }

    public static void setVisibility(FieldNode fieldNode, int n) {
        int n2 = fieldNode.getModifiers();
        fieldNode.setModifiers((n2 &= 0xFFFFFFF8) | n);
    }

    public static boolean isJointCompiled(ClassNode classNode) {
        return classNode.getModule().getUnit().getConfig().getJointCompilationOptions() != null;
    }

    public static void deleteMethod(ClassNode classNode, MethodNode methodNode) {
        classNode.getMethods().remove(methodNode);
        classNode.getDeclaredMethods(methodNode.getName()).remove(methodNode);
    }
}

