/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.RegexExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.syntax.Types;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.OldValueExpression;
import org.spockframework.util.AbstractExpressionConverter;
import org.spockframework.util.Assert;
import org.spockframework.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionRewriter
extends AbstractExpressionConverter<Expression> {
    private final IRewriteResources resources;
    private int recordCount = 0;
    private boolean doNotRecordNextConstant = false;

    private ConditionRewriter(IRewriteResources iRewriteResources) {
        this.resources = iRewriteResources;
    }

    public static Statement rewriteExplicitCondition(AssertStatement assertStatement, IRewriteResources iRewriteResources) {
        ConditionRewriter conditionRewriter = new ConditionRewriter(iRewriteResources);
        Expression expression = AstUtil.getAssertionMessage(assertStatement);
        return conditionRewriter.rewriteCondition((Statement)assertStatement, assertStatement.getBooleanExpression().getExpression(), expression, true);
    }

    public static Statement rewriteImplicitCondition(ExpressionStatement expressionStatement, IRewriteResources iRewriteResources) {
        ConditionRewriter conditionRewriter = new ConditionRewriter(iRewriteResources);
        return conditionRewriter.rewriteCondition((Statement)expressionStatement, expressionStatement.getExpression(), null, false);
    }

    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        boolean bl = !methodCallExpression.isImplicitThis() && methodCallExpression.getObjectExpression() instanceof VariableExpression && "call".equals(methodCallExpression.getMethodAsString()) && (!AstUtil.hasPlausibleSourcePosition((ASTNode)methodCallExpression.getMethod()) || methodCallExpression.getMethod().getColumnNumber() == methodCallExpression.getObjectExpression().getColumnNumber());
        MethodCallExpression methodCallExpression2 = new MethodCallExpression(methodCallExpression.isImplicitThis() ? methodCallExpression.getObjectExpression() : (Expression)this.convert(methodCallExpression.getObjectExpression()), bl ? methodCallExpression.getMethod() : (Expression)this.convert(methodCallExpression.getMethod()), (Expression)this.convert(methodCallExpression.getArguments()));
        methodCallExpression2.setSafe(methodCallExpression.isSafe());
        methodCallExpression2.setSpreadSafe(methodCallExpression.isSpreadSafe());
        methodCallExpression2.setSourcePosition((ASTNode)methodCallExpression);
        this.result = this.record((Expression)methodCallExpression2);
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression staticMethodCallExpression) {
        StaticMethodCallExpression staticMethodCallExpression2 = new StaticMethodCallExpression(staticMethodCallExpression.getOwnerType(), this.recordNa(staticMethodCallExpression.getMethod()), (Expression)this.convert(staticMethodCallExpression.getArguments()));
        staticMethodCallExpression2.setSourcePosition((ASTNode)staticMethodCallExpression);
        staticMethodCallExpression2.setMetaMethod(staticMethodCallExpression.getMetaMethod());
        this.result = this.record((Expression)staticMethodCallExpression2);
    }

    public void visitBytecodeExpression(BytecodeExpression bytecodeExpression) {
        this.unsupported();
    }

    public void visitArgumentlistExpression(ArgumentListExpression argumentListExpression) {
        ArgumentListExpression argumentListExpression2 = new ArgumentListExpression(this.convertAll(argumentListExpression.getExpressions()));
        argumentListExpression2.setSourcePosition((ASTNode)argumentListExpression);
        this.result = this.recordNa(argumentListExpression2);
    }

    public void visitPropertyExpression(PropertyExpression propertyExpression) {
        PropertyExpression propertyExpression2 = new PropertyExpression(propertyExpression.isImplicitThis() ? propertyExpression.getObjectExpression() : (Expression)this.convert(propertyExpression.getObjectExpression()), propertyExpression.getProperty(), propertyExpression.isSafe());
        propertyExpression2.setSourcePosition((ASTNode)propertyExpression);
        propertyExpression2.setSpreadSafe(propertyExpression.isSpreadSafe());
        propertyExpression2.setStatic(propertyExpression.isStatic());
        propertyExpression2.setImplicitThis(propertyExpression.isImplicitThis());
        this.result = this.record((Expression)propertyExpression2);
    }

    public void visitAttributeExpression(AttributeExpression attributeExpression) {
        AttributeExpression attributeExpression2 = new AttributeExpression(attributeExpression.isImplicitThis() ? attributeExpression.getObjectExpression() : (Expression)this.convert(attributeExpression.getObjectExpression()), attributeExpression.getProperty(), attributeExpression.isSafe());
        attributeExpression2.setSourcePosition((ASTNode)attributeExpression);
        attributeExpression2.setSpreadSafe(attributeExpression.isSpreadSafe());
        attributeExpression2.setStatic(attributeExpression.isStatic());
        attributeExpression2.setImplicitThis(attributeExpression.isImplicitThis());
        this.result = this.record((Expression)attributeExpression2);
    }

    public void visitFieldExpression(FieldExpression fieldExpression) {
        this.result = this.record((Expression)fieldExpression);
    }

    public void visitMethodPointerExpression(MethodPointerExpression methodPointerExpression) {
        MethodPointerExpression methodPointerExpression2 = new MethodPointerExpression((Expression)this.convert(methodPointerExpression.getExpression()), (Expression)this.convert(methodPointerExpression.getMethodName()));
        methodPointerExpression2.setSourcePosition((ASTNode)methodPointerExpression);
        this.result = this.record((Expression)methodPointerExpression2);
    }

    public void visitVariableExpression(VariableExpression variableExpression) {
        if (variableExpression instanceof OldValueExpression) {
            Expression expression = ((OldValueExpression)variableExpression).getOrginalExpression();
            expression.visit((GroovyCodeVisitor)this);
            this.doNotRecordNextConstant = true;
            this.result = variableExpression;
            return;
        }
        this.result = this.record((Expression)variableExpression);
    }

    public void visitDeclarationExpression(DeclarationExpression declarationExpression) {
        this.unsupported();
    }

    public void visitRegexExpression(RegexExpression regexExpression) {
        this.unsupported();
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        BinaryExpression binaryExpression2 = new BinaryExpression(Types.ofType((int)binaryExpression.getOperation().getType(), (int)1100) ? this.convertAndRecordNa(binaryExpression.getLeftExpression()) : (Expression)this.convert(binaryExpression.getLeftExpression()), binaryExpression.getOperation(), (Expression)this.convert(binaryExpression.getRightExpression()));
        binaryExpression2.setSourcePosition((ASTNode)binaryExpression);
        this.result = this.record((Expression)binaryExpression2);
    }

    public void visitConstantExpression(ConstantExpression constantExpression) {
        if (this.doNotRecordNextConstant) {
            this.doNotRecordNextConstant = false;
            this.result = constantExpression;
            return;
        }
        this.result = this.record((Expression)constantExpression);
    }

    public void visitClassExpression(ClassExpression classExpression) {
        this.result = classExpression;
        if (!AstUtil.hasPlausibleSourcePosition((ASTNode)classExpression)) {
            return;
        }
        String string = this.resources.getSourceText((ASTNode)classExpression);
        this.recordCount += string == null ? 1 : TextUtil.countOccurrences(string, '.') + 1;
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression unaryMinusExpression) {
        UnaryMinusExpression unaryMinusExpression2 = new UnaryMinusExpression((Expression)this.convert(unaryMinusExpression.getExpression()));
        unaryMinusExpression2.setSourcePosition((ASTNode)unaryMinusExpression);
        this.result = this.record((Expression)unaryMinusExpression2);
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression unaryPlusExpression) {
        UnaryPlusExpression unaryPlusExpression2 = new UnaryPlusExpression((Expression)this.convert(unaryPlusExpression.getExpression()));
        unaryPlusExpression2.setSourcePosition((ASTNode)unaryPlusExpression);
        this.result = this.record((Expression)unaryPlusExpression2);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression bitwiseNegationExpression) {
        BitwiseNegationExpression bitwiseNegationExpression2 = new BitwiseNegationExpression((Expression)this.convert(bitwiseNegationExpression.getExpression()));
        bitwiseNegationExpression2.setSourcePosition((ASTNode)bitwiseNegationExpression);
        this.result = this.record((Expression)bitwiseNegationExpression2);
    }

    public void visitCastExpression(CastExpression castExpression) {
        CastExpression castExpression2 = new CastExpression(castExpression.getType(), (Expression)this.convert(castExpression.getExpression()), castExpression.isIgnoringAutoboxing());
        castExpression2.setSourcePosition((ASTNode)castExpression);
        castExpression2.setCoerce(castExpression.isCoerce());
        this.result = this.record((Expression)castExpression2);
    }

    public void visitClosureListExpression(ClosureListExpression closureListExpression) {
        this.unsupported();
    }

    public void visitNotExpression(NotExpression notExpression) {
        NotExpression notExpression2 = new NotExpression((Expression)this.convert(notExpression.getExpression()));
        notExpression2.setSourcePosition((ASTNode)notExpression);
        this.result = this.record((Expression)notExpression2);
    }

    public void visitListExpression(ListExpression listExpression) {
        ListExpression listExpression2 = new ListExpression(this.convertAll(listExpression.getExpressions()));
        listExpression2.setSourcePosition((ASTNode)listExpression);
        this.result = this.record((Expression)listExpression2);
    }

    public void visitRangeExpression(RangeExpression rangeExpression) {
        RangeExpression rangeExpression2 = new RangeExpression((Expression)this.convert(rangeExpression.getFrom()), (Expression)this.convert(rangeExpression.getTo()), rangeExpression.isInclusive());
        rangeExpression2.setSourcePosition((ASTNode)rangeExpression);
        this.result = this.record((Expression)rangeExpression2);
    }

    public void visitMapExpression(MapExpression mapExpression) {
        boolean bl = mapExpression instanceof NamedArgumentListExpression;
        NamedArgumentListExpression namedArgumentListExpression = bl ? new NamedArgumentListExpression(this.convertAll(mapExpression.getMapEntryExpressions())) : new MapExpression(this.convertAll(mapExpression.getMapEntryExpressions()));
        namedArgumentListExpression.setSourcePosition((ASTNode)mapExpression);
        this.result = bl ? (Expression)this.recordNa(namedArgumentListExpression) : this.record((Expression)namedArgumentListExpression);
    }

    public void visitMapEntryExpression(MapEntryExpression mapEntryExpression) {
        MapEntryExpression mapEntryExpression2 = new MapEntryExpression((Expression)this.convert(mapEntryExpression.getKeyExpression()), (Expression)this.convert(mapEntryExpression.getValueExpression()));
        mapEntryExpression2.setSourcePosition((ASTNode)mapEntryExpression);
        this.result = this.recordNa(mapEntryExpression2);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression constructorCallExpression) {
        ConstructorCallExpression constructorCallExpression2 = new ConstructorCallExpression(constructorCallExpression.getType(), (Expression)this.convert(constructorCallExpression.getArguments()));
        constructorCallExpression2.setSourcePosition((ASTNode)constructorCallExpression);
        this.result = this.record((Expression)constructorCallExpression2);
    }

    public void visitGStringExpression(GStringExpression gStringExpression) {
        GStringExpression gStringExpression2 = new GStringExpression(gStringExpression.getText(), gStringExpression.getStrings(), this.convertAll(gStringExpression.getValues()));
        gStringExpression2.setSourcePosition((ASTNode)gStringExpression);
        this.result = this.record((Expression)gStringExpression2);
    }

    public void visitArrayExpression(ArrayExpression arrayExpression) {
        ArrayExpression arrayExpression2 = new ArrayExpression(arrayExpression.getElementType(), this.convertAll(arrayExpression.getExpressions()), this.convertAll(arrayExpression.getSizeExpression()));
        arrayExpression2.setSourcePosition((ASTNode)arrayExpression);
        this.result = this.record((Expression)arrayExpression2);
    }

    public void visitSpreadExpression(SpreadExpression spreadExpression) {
        SpreadExpression spreadExpression2 = new SpreadExpression((Expression)this.convert(spreadExpression.getExpression()));
        spreadExpression2.setSourcePosition((ASTNode)spreadExpression);
        this.result = this.recordNa(spreadExpression2);
    }

    public void visitSpreadMapExpression(SpreadMapExpression spreadMapExpression) {
        this.result = this.recordNa(spreadMapExpression);
    }

    public void visitTernaryExpression(TernaryExpression ternaryExpression) {
        TernaryExpression ternaryExpression2 = new TernaryExpression(this.convertCompatibly(ternaryExpression.getBooleanExpression()), (Expression)this.convert(ternaryExpression.getTrueExpression()), (Expression)this.convert(ternaryExpression.getFalseExpression()));
        ternaryExpression2.setSourcePosition((ASTNode)ternaryExpression);
        this.result = this.record((Expression)ternaryExpression2);
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression elvisOperatorExpression) {
        ElvisOperatorExpression elvisOperatorExpression2 = new ElvisOperatorExpression((Expression)this.convert(elvisOperatorExpression.getTrueExpression()), (Expression)this.convert(elvisOperatorExpression.getFalseExpression()));
        elvisOperatorExpression2.setSourcePosition((ASTNode)elvisOperatorExpression);
        this.result = this.record((Expression)elvisOperatorExpression2);
    }

    public void visitPrefixExpression(PrefixExpression prefixExpression) {
        PrefixExpression prefixExpression2 = new PrefixExpression(prefixExpression.getOperation(), this.convertAndRecordNa(prefixExpression.getExpression()));
        prefixExpression2.setSourcePosition((ASTNode)prefixExpression);
        this.result = this.record((Expression)prefixExpression2);
    }

    public void visitPostfixExpression(PostfixExpression postfixExpression) {
        PostfixExpression postfixExpression2 = new PostfixExpression(this.convertAndRecordNa(postfixExpression.getExpression()), postfixExpression.getOperation());
        postfixExpression2.setSourcePosition((ASTNode)postfixExpression);
        this.result = this.record((Expression)postfixExpression2);
    }

    public void visitBooleanExpression(BooleanExpression booleanExpression) {
        BooleanExpression booleanExpression2 = new BooleanExpression((Expression)this.convert(booleanExpression.getExpression()));
        booleanExpression2.setSourcePosition((ASTNode)booleanExpression);
        this.result = this.recordNa(booleanExpression2);
    }

    public void visitClosureExpression(ClosureExpression closureExpression) {
        this.result = this.record((Expression)closureExpression);
    }

    public void visitTupleExpression(TupleExpression tupleExpression) {
        TupleExpression tupleExpression2 = new TupleExpression(this.convertAllAndRecordNa(tupleExpression.getExpressions()));
        tupleExpression2.setSourcePosition((ASTNode)tupleExpression);
        this.result = this.recordNa(tupleExpression2);
    }

    private Expression record(Expression expression) {
        return new MethodCallExpression((Expression)new VariableExpression("$spock_valueRecorder"), "record", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)this.recordCount++), expression));
    }

    private Expression realizeNas(Expression expression) {
        return new MethodCallExpression((Expression)new VariableExpression("$spock_valueRecorder"), "realizeNas", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)this.recordCount), expression));
    }

    private <T> T recordNa(T t) {
        ++this.recordCount;
        return t;
    }

    private Expression convertAndRecordNa(Expression expression) {
        return this.unrecord((Expression)this.convert(expression));
    }

    private List<Expression> convertAllAndRecordNa(List<Expression> list) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(list.size());
        for (Expression expression : list) {
            arrayList.add(this.convertAndRecordNa(expression));
        }
        return arrayList;
    }

    private <T extends Expression> T convertCompatibly(T t) {
        Expression expression = (Expression)this.convert(t);
        Assert.that(t.getClass().isInstance(expression));
        return (T)expression;
    }

    private Expression unrecord(Expression expression) {
        if (!(expression instanceof MethodCallExpression)) {
            return expression;
        }
        MethodCallExpression methodCallExpression = (MethodCallExpression)expression;
        Expression expression2 = methodCallExpression.getObjectExpression();
        if (!(expression2 instanceof VariableExpression)) {
            return expression;
        }
        VariableExpression variableExpression = (VariableExpression)expression2;
        if (!variableExpression.getName().equals("$spock_valueRecorder")) {
            return expression;
        }
        if (!methodCallExpression.getMethodAsString().equals("record")) {
            return expression;
        }
        return ((ArgumentListExpression)methodCallExpression.getArguments()).getExpression(1);
    }

    private Statement rewriteCondition(Statement statement, Expression expression, Expression expression2, boolean bl) {
        ExpressionStatement expressionStatement = new ExpressionStatement(this.rewriteCondition(expression, expression2, bl));
        expressionStatement.setSourcePosition((ASTNode)statement);
        return expressionStatement;
    }

    private Expression rewriteCondition(Expression expression, Expression expression2, boolean bl) {
        if (expression instanceof MethodCallExpression && !((MethodCallExpression)expression).isSpreadSafe()) {
            return this.rewriteMethodCondition((MethodCallExpression)expression, expression2, bl);
        }
        if (expression instanceof StaticMethodCallExpression) {
            return this.rewriteStaticMethodCondition((StaticMethodCallExpression)expression, expression2, bl);
        }
        return this.rewriteOtherCondition(expression, expression2);
    }

    private Expression rewriteMethodCondition(MethodCallExpression methodCallExpression, Expression expression, boolean bl) {
        MethodCallExpression methodCallExpression2 = expression == null ? (MethodCallExpression)this.unrecord((Expression)this.convert((Expression)methodCallExpression)) : methodCallExpression;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(methodCallExpression2.getObjectExpression());
        arrayList.add(methodCallExpression2.getMethod());
        arrayList.add(AstUtil.toArgumentArray(AstUtil.getArguments(methodCallExpression2), this.resources));
        arrayList.add(this.realizeNas((Expression)new ConstantExpression((Object)methodCallExpression2.isSafe())));
        arrayList.add((Expression)new ConstantExpression((Object)bl));
        return this.rewriteToSpockRuntimeCall("verifyMethodCondition", (Expression)methodCallExpression, expression, arrayList);
    }

    private Expression rewriteStaticMethodCondition(StaticMethodCallExpression staticMethodCallExpression, Expression expression, boolean bl) {
        StaticMethodCallExpression staticMethodCallExpression2 = expression == null ? (StaticMethodCallExpression)this.unrecord((Expression)this.convert((Expression)staticMethodCallExpression)) : staticMethodCallExpression;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add((Expression)new ClassExpression(staticMethodCallExpression2.getOwnerType()));
        arrayList.add((Expression)new ConstantExpression((Object)staticMethodCallExpression2.getMethod()));
        arrayList.add(AstUtil.toArgumentArray(AstUtil.getArguments(staticMethodCallExpression2), this.resources));
        arrayList.add(this.realizeNas((Expression)ConstantExpression.FALSE));
        arrayList.add((Expression)new ConstantExpression((Object)bl));
        return this.rewriteToSpockRuntimeCall("verifyMethodCondition", (Expression)staticMethodCallExpression, expression, arrayList);
    }

    private Expression rewriteOtherCondition(Expression expression, Expression expression2) {
        Expression expression3 = expression2 == null ? (Expression)this.convert(expression) : expression;
        return this.rewriteToSpockRuntimeCall("verifyCondition", expression, expression2, Collections.singletonList(expression3));
    }

    private Expression rewriteToSpockRuntimeCall(String string, Expression expression, Expression expression2, List<Expression> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MethodCallExpression methodCallExpression = new MethodCallExpression((Expression)new ClassExpression(this.resources.getAstNodeCache().SpockRuntime), (Expression)new ConstantExpression((Object)string), (Expression)new ArgumentListExpression(arrayList));
        arrayList.add(expression2 == null ? new MethodCallExpression((Expression)new VariableExpression("$spock_valueRecorder"), "reset", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS) : new ConstantExpression(null));
        arrayList.add(new ConstantExpression((Object)this.resources.getSourceText((ASTNode)expression)));
        arrayList.add(new ConstantExpression((Object)expression.getLineNumber()));
        arrayList.add(new ConstantExpression((Object)expression.getColumnNumber()));
        arrayList.add(expression2 == null ? new ConstantExpression(null) : expression2);
        arrayList.addAll(list);
        methodCallExpression.setSourcePosition((ASTNode)expression);
        return methodCallExpression;
    }
}

