/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ConditionRewriter;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.InteractionRewriter;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.compiler.StatementReplacingVisitorSupport;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.FeatureMethod;
import org.spockframework.compiler.model.FixtureMethod;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.ThenBlock;

public class DeepStatementRewriter
extends StatementReplacingVisitorSupport {
    private final IRewriteResources resources;
    private boolean conditionFound = false;
    private boolean interactionFound = false;
    private VariableScope closureScope;

    public DeepStatementRewriter(IRewriteResources iRewriteResources) {
        this.resources = iRewriteResources;
    }

    public boolean isConditionFound() {
        return this.conditionFound;
    }

    public boolean isInteractionFound() {
        return this.interactionFound;
    }

    public void visitBlock(Block block) {
        this.replaceAll((List)block.getAst());
    }

    public void visitAssertStatement(AssertStatement assertStatement) {
        super.visitAssertStatement(assertStatement);
        this.conditionFound = true;
        this.replaceVisitedStatementWith(ConditionRewriter.rewriteExplicitCondition(assertStatement, this.resources));
    }

    public void visitExpressionStatement(ExpressionStatement expressionStatement) {
        super.visitExpressionStatement(expressionStatement);
        Statement statement = new InteractionRewriter(this.resources).rewrite(expressionStatement);
        if (statement == null) {
            return;
        }
        this.interactionFound = true;
        this.replaceVisitedStatementWith(statement);
    }

    public void visitClosureExpression(ClosureExpression closureExpression) {
        boolean bl = this.conditionFound;
        boolean bl2 = this.interactionFound;
        VariableScope variableScope = this.closureScope;
        this.conditionFound = false;
        this.interactionFound = false;
        this.closureScope = closureExpression.getVariableScope();
        this.fixupParameters(this.closureScope, true);
        super.visitClosureExpression(closureExpression);
        if (this.conditionFound) {
            this.defineValueRecorder(closureExpression);
        }
        this.conditionFound = bl;
        this.interactionFound = bl2;
        this.closureScope = variableScope;
    }

    private void defineValueRecorder(ClosureExpression closureExpression) {
        this.resources.defineValueRecorder(AstUtil.getStatements(closureExpression));
    }

    private void fixupParameters(VariableScope variableScope, boolean bl) {
        Method method = this.resources.getCurrentMethod();
        if (!(method instanceof FeatureMethod)) {
            return;
        }
        for (Parameter parameter : ((MethodNode)method.getAst()).getParameters()) {
            Variable variable = variableScope.getReferencedClassVariable(parameter.getName());
            if (!(variable instanceof DynamicVariable)) continue;
            variableScope.removeReferencedClassVariable(parameter.getName());
            variableScope.putReferencedLocalVariable((Variable)parameter);
            if (!bl) continue;
            parameter.setClosureSharedVariable(true);
        }
    }

    public void visitBlockStatement(BlockStatement blockStatement) {
        super.visitBlockStatement(blockStatement);
        this.fixupParameters(blockStatement.getVariableScope(), false);
    }

    public void visitDeclarationExpression(DeclarationExpression declarationExpression) {
        this.visitBinaryExpression((BinaryExpression)declarationExpression);
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        if (AstUtil.isBuiltinMemberAssignment(binaryExpression, "Mock", 0, 1)) {
            try {
                AstUtil.expandBuiltinMemberAssignment(binaryExpression, new Expression[]{this.resources.getMockControllerRef()});
            }
            catch (InvalidSpecCompileException invalidSpecCompileException) {
                this.resources.getErrorReporter().error(invalidSpecCompileException);
                return;
            }
        }
        super.visitBinaryExpression(binaryExpression);
    }

    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        super.visitMethodCallExpression(methodCallExpression);
        this.forbidUseOfSuperInFixtureMethod(methodCallExpression);
        this.handleMockAndOldCalls((Expression)methodCallExpression);
    }

    private void forbidUseOfSuperInFixtureMethod(MethodCallExpression methodCallExpression) {
        Method method = this.resources.getCurrentMethod();
        Expression expression = methodCallExpression.getObjectExpression();
        if (method instanceof FixtureMethod && expression instanceof VariableExpression && ((VariableExpression)expression).isSuperExpression() && method.getName().equals(methodCallExpression.getMethodAsString())) {
            this.resources.getErrorReporter().error((ASTNode)methodCallExpression, "A base class fixture method should not be called explicitely because it is always run automatically by the framework", new Object[0]);
        }
    }

    private void handleMockAndOldCalls(Expression expression) {
        if (AstUtil.isBuiltinMemberCall(expression, "Mock", 0, 1)) {
            this.handleMockCall(expression);
        } else if (AstUtil.isBuiltinMemberCall(expression, "old", 1, 1)) {
            this.handleOldCall(expression);
        }
    }

    private void handleMockCall(Expression expression) {
        try {
            AstUtil.expandBuiltinMemberCall(expression, new Expression[]{this.resources.getMockControllerRef()});
        }
        catch (InvalidSpecCompileException invalidSpecCompileException) {
            this.resources.getErrorReporter().error(invalidSpecCompileException);
        }
    }

    private void handleOldCall(Expression expression) {
        if (!(this.resources.getCurrentBlock() instanceof ThenBlock)) {
            this.resources.getErrorReporter().error((ASTNode)expression, "old() may only be used in a 'then' block", new Object[0]);
            return;
        }
        List<Expression> list = AstUtil.getArguments(expression);
        VariableExpression variableExpression = this.resources.captureOldValue(list.get(0));
        list.set(0, (Expression)variableExpression);
        list.add((Expression)ConstantExpression.FALSE);
        if (this.closureScope != null) {
            variableExpression.setClosureSharedVariable(true);
            this.closureScope.putReferencedLocalVariable((Variable)variableExpression);
        }
    }
}

