/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.util.TextUtil;

public class ErrorReporter {
    private final SourceUnit sourceUnit;

    public ErrorReporter(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    public void error(String string, Object ... objectArray) {
        this.sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage(String.format(string, objectArray), (ProcessingUnit)this.sourceUnit));
    }

    public void error(String string, Throwable throwable, Object ... objectArray) {
        this.sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage(String.format(string, objectArray) + "\n\n" + TextUtil.printStackTrace(throwable), (ProcessingUnit)this.sourceUnit));
    }

    public void error(ASTNode aSTNode, String string, Object ... objectArray) {
        this.error(new InvalidSpecCompileException(aSTNode, string, objectArray));
    }

    public void error(int n, int n2, String string, Object ... objectArray) {
        this.error(new InvalidSpecCompileException(n, n2, string, objectArray));
    }

    public void error(InvalidSpecCompileException invalidSpecCompileException) {
        this.sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SyntaxErrorMessage((SyntaxException)invalidSpecCompileException, this.sourceUnit));
    }
}

