/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.RegexExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.spockframework.compiler.StatementReplacingVisitorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionReplacingVisitorSupport
extends StatementReplacingVisitorSupport {
    private Expression replacementExpr;

    public Expression replaceExpr(Expression expression) {
        this.replacementExpr = null;
        expression.visit((GroovyCodeVisitor)this);
        Expression expression2 = this.replacementExpr == null ? expression : this.replacementExpr;
        this.replacementExpr = null;
        return expression2;
    }

    protected <T extends Expression> void replaceAllExprs(List<T> list) {
        ListIterator<T> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.set(this.replaceExpr((Expression)listIterator.next()));
        }
    }

    protected void replaceVisitedExpressionWith(Expression expression) {
        this.replacementExpr = expression;
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) {
        this.replaceAll(blockStatement.getStatements());
    }

    @Override
    public void visitForLoop(ForStatement forStatement) {
        forStatement.setCollectionExpression(this.replaceExpr(forStatement.getCollectionExpression()));
        forStatement.setLoopBlock(this.replace(forStatement.getLoopBlock()));
    }

    @Override
    public void visitWhileLoop(WhileStatement whileStatement) {
        whileStatement.setBooleanExpression((BooleanExpression)this.replaceExpr((Expression)whileStatement.getBooleanExpression()));
        whileStatement.setLoopBlock(this.replace(whileStatement.getLoopBlock()));
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement doWhileStatement) {
        doWhileStatement.setBooleanExpression((BooleanExpression)this.replaceExpr((Expression)doWhileStatement.getBooleanExpression()));
        doWhileStatement.setLoopBlock(this.replace(doWhileStatement.getLoopBlock()));
    }

    @Override
    public void visitIfElse(IfStatement ifStatement) {
        ifStatement.setBooleanExpression((BooleanExpression)this.replaceExpr((Expression)ifStatement.getBooleanExpression()));
        ifStatement.setIfBlock(this.replace(ifStatement.getIfBlock()));
        ifStatement.setElseBlock(this.replace(ifStatement.getElseBlock()));
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement tryCatchStatement) {
        tryCatchStatement.setTryStatement(this.replace(tryCatchStatement.getTryStatement()));
        this.replaceAll(tryCatchStatement.getCatchStatements());
        tryCatchStatement.setFinallyStatement(this.replace(tryCatchStatement.getFinallyStatement()));
    }

    @Override
    public void visitSwitch(SwitchStatement switchStatement) {
        switchStatement.setExpression(this.replaceExpr(switchStatement.getExpression()));
        this.replaceAll(switchStatement.getCaseStatements());
        switchStatement.setDefaultStatement(this.replace(switchStatement.getDefaultStatement()));
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) {
        caseStatement.setExpression(this.replaceExpr(caseStatement.getExpression()));
        caseStatement.setCode(this.replace(caseStatement.getCode()));
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement synchronizedStatement) {
        synchronizedStatement.setExpression(this.replaceExpr(synchronizedStatement.getExpression()));
        synchronizedStatement.setCode(this.replace(synchronizedStatement.getCode()));
    }

    @Override
    public void visitCatchStatement(CatchStatement catchStatement) {
        catchStatement.setCode(this.replace(catchStatement.getCode()));
    }

    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        methodCallExpression.setObjectExpression(this.replaceExpr(methodCallExpression.getObjectExpression()));
        methodCallExpression.setMethod(this.replaceExpr(methodCallExpression.getMethod()));
        methodCallExpression.setArguments(this.replaceExpr(methodCallExpression.getArguments()));
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression staticMethodCallExpression) {
        StaticMethodCallExpression staticMethodCallExpression2 = new StaticMethodCallExpression(staticMethodCallExpression.getOwnerType(), staticMethodCallExpression.getMethod(), this.replaceExpr(staticMethodCallExpression.getArguments()));
        staticMethodCallExpression2.setType(staticMethodCallExpression.getType());
        staticMethodCallExpression2.setSourcePosition((ASTNode)staticMethodCallExpression);
        this.replaceVisitedExpressionWith((Expression)staticMethodCallExpression2);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression constructorCallExpression) {
        ConstructorCallExpression constructorCallExpression2 = new ConstructorCallExpression(constructorCallExpression.getType(), this.replaceExpr(constructorCallExpression.getArguments()));
        constructorCallExpression2.setSourcePosition((ASTNode)constructorCallExpression);
        this.replaceVisitedExpressionWith((Expression)constructorCallExpression2);
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        binaryExpression.setLeftExpression(this.replaceExpr(binaryExpression.getLeftExpression()));
        binaryExpression.setRightExpression(this.replaceExpr(binaryExpression.getRightExpression()));
    }

    public void visitTernaryExpression(TernaryExpression ternaryExpression) {
        TernaryExpression ternaryExpression2 = new TernaryExpression((BooleanExpression)this.replaceExpr((Expression)ternaryExpression.getBooleanExpression()), this.replaceExpr(ternaryExpression.getTrueExpression()), this.replaceExpr(ternaryExpression.getFalseExpression()));
        ternaryExpression2.setType(ternaryExpression.getType());
        ternaryExpression2.setSourcePosition((ASTNode)ternaryExpression);
        this.replaceVisitedExpressionWith((Expression)ternaryExpression2);
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression elvisOperatorExpression) {
        ElvisOperatorExpression elvisOperatorExpression2 = new ElvisOperatorExpression(this.replaceExpr(elvisOperatorExpression.getTrueExpression()), this.replaceExpr(elvisOperatorExpression.getFalseExpression()));
        elvisOperatorExpression2.setType(elvisOperatorExpression.getType());
        elvisOperatorExpression2.setSourcePosition((ASTNode)elvisOperatorExpression);
        this.replaceVisitedExpressionWith((Expression)elvisOperatorExpression2);
    }

    public void visitPostfixExpression(PostfixExpression postfixExpression) {
        postfixExpression.setExpression(this.replaceExpr(postfixExpression.getExpression()));
    }

    public void visitPrefixExpression(PrefixExpression prefixExpression) {
        prefixExpression.setExpression(this.replaceExpr(prefixExpression.getExpression()));
    }

    public void visitBooleanExpression(BooleanExpression booleanExpression) {
        BooleanExpression booleanExpression2 = new BooleanExpression(this.replaceExpr(booleanExpression.getExpression()));
        booleanExpression2.setType(booleanExpression.getType());
        booleanExpression2.setSourcePosition((ASTNode)booleanExpression);
        this.replaceVisitedExpressionWith((Expression)booleanExpression2);
    }

    public void visitNotExpression(NotExpression notExpression) {
        NotExpression notExpression2 = new NotExpression(this.replaceExpr(notExpression.getExpression()));
        notExpression2.setType(notExpression.getType());
        notExpression2.setSourcePosition((ASTNode)notExpression);
        this.replaceVisitedExpressionWith((Expression)notExpression2);
    }

    public void visitClosureExpression(ClosureExpression closureExpression) {
        super.visitClosureExpression(closureExpression);
        this.replaceVisitedExpressionWith((Expression)closureExpression);
    }

    public void visitTupleExpression(TupleExpression tupleExpression) {
        this.replaceAllExprs(tupleExpression.getExpressions());
    }

    public void visitListExpression(ListExpression listExpression) {
        this.replaceAllExprs(listExpression.getExpressions());
    }

    public void visitArrayExpression(ArrayExpression arrayExpression) {
        this.replaceAllExprs(arrayExpression.getExpressions());
        this.replaceAllExprs(arrayExpression.getSizeExpression());
    }

    public void visitMapExpression(MapExpression mapExpression) {
        this.replaceAllExprs(mapExpression.getMapEntryExpressions());
    }

    public void visitMapEntryExpression(MapEntryExpression mapEntryExpression) {
        MapEntryExpression mapEntryExpression2 = new MapEntryExpression(this.replaceExpr(mapEntryExpression.getKeyExpression()), this.replaceExpr(mapEntryExpression.getValueExpression()));
        mapEntryExpression2.setType(mapEntryExpression.getType());
        mapEntryExpression2.setSourcePosition((ASTNode)mapEntryExpression);
        this.replaceVisitedExpressionWith((Expression)mapEntryExpression2);
    }

    public void visitRangeExpression(RangeExpression rangeExpression) {
        RangeExpression rangeExpression2 = new RangeExpression(this.replaceExpr(rangeExpression.getFrom()), this.replaceExpr(rangeExpression.getTo()), rangeExpression.isInclusive());
        rangeExpression2.setType(rangeExpression.getType());
        rangeExpression2.setSourcePosition((ASTNode)rangeExpression);
        this.replaceVisitedExpressionWith((Expression)rangeExpression2);
    }

    public void visitSpreadExpression(SpreadExpression spreadExpression) {
        SpreadExpression spreadExpression2 = new SpreadExpression(this.replaceExpr(spreadExpression.getExpression()));
        spreadExpression2.setType(spreadExpression.getType());
        spreadExpression2.setSourcePosition((ASTNode)spreadExpression);
        this.replaceVisitedExpressionWith((Expression)spreadExpression2);
    }

    public void visitSpreadMapExpression(SpreadMapExpression spreadMapExpression) {
        SpreadMapExpression spreadMapExpression2 = new SpreadMapExpression(this.replaceExpr(spreadMapExpression.getExpression()));
        spreadMapExpression2.setType(spreadMapExpression.getType());
        spreadMapExpression2.setSourcePosition((ASTNode)spreadMapExpression);
        this.replaceVisitedExpressionWith((Expression)spreadMapExpression2);
    }

    public void visitMethodPointerExpression(MethodPointerExpression methodPointerExpression) {
        MethodPointerExpression methodPointerExpression2 = new MethodPointerExpression(this.replaceExpr(methodPointerExpression.getExpression()), methodPointerExpression.getMethodName());
        methodPointerExpression2.setType(methodPointerExpression.getType());
        methodPointerExpression2.setSourcePosition((ASTNode)methodPointerExpression);
        this.replaceVisitedExpressionWith((Expression)methodPointerExpression2);
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression unaryMinusExpression) {
        UnaryMinusExpression unaryMinusExpression2 = new UnaryMinusExpression(this.replaceExpr(unaryMinusExpression.getExpression()));
        unaryMinusExpression2.setType(unaryMinusExpression.getType());
        unaryMinusExpression2.setSourcePosition((ASTNode)unaryMinusExpression);
        this.replaceVisitedExpressionWith((Expression)unaryMinusExpression2);
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression unaryPlusExpression) {
        UnaryPlusExpression unaryPlusExpression2 = new UnaryPlusExpression(this.replaceExpr(unaryPlusExpression.getExpression()));
        unaryPlusExpression2.setType(unaryPlusExpression.getType());
        unaryPlusExpression2.setSourcePosition((ASTNode)unaryPlusExpression);
        this.replaceVisitedExpressionWith((Expression)unaryPlusExpression2);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression bitwiseNegationExpression) {
        BitwiseNegationExpression bitwiseNegationExpression2 = new BitwiseNegationExpression(this.replaceExpr(bitwiseNegationExpression.getExpression()));
        bitwiseNegationExpression2.setType(bitwiseNegationExpression.getType());
        bitwiseNegationExpression2.setSourcePosition((ASTNode)bitwiseNegationExpression);
        this.replaceVisitedExpressionWith((Expression)bitwiseNegationExpression2);
    }

    public void visitCastExpression(CastExpression castExpression) {
        CastExpression castExpression2 = new CastExpression(castExpression.getType(), this.replaceExpr(castExpression.getExpression()), castExpression.isIgnoringAutoboxing());
        castExpression2.setCoerce(castExpression.isCoerce());
        castExpression2.setType(castExpression.getType());
        castExpression2.setSourcePosition((ASTNode)castExpression);
        this.replaceVisitedExpressionWith((Expression)castExpression2);
    }

    public void visitDeclarationExpression(DeclarationExpression declarationExpression) {
        this.visitBinaryExpression((BinaryExpression)declarationExpression);
        this.replaceVisitedExpressionWith((Expression)declarationExpression);
    }

    public void visitPropertyExpression(PropertyExpression propertyExpression) {
        PropertyExpression propertyExpression2 = new PropertyExpression(this.replaceExpr(propertyExpression.getObjectExpression()), this.replaceExpr(propertyExpression.getProperty()), propertyExpression.isSafe());
        propertyExpression2.setSpreadSafe(propertyExpression.isSpreadSafe());
        propertyExpression2.setStatic(propertyExpression.isStatic());
        propertyExpression2.setImplicitThis(propertyExpression.isImplicitThis());
        propertyExpression2.setType(propertyExpression.getType());
        propertyExpression2.setSourcePosition((ASTNode)propertyExpression);
        this.replaceVisitedExpressionWith((Expression)propertyExpression2);
    }

    public void visitAttributeExpression(AttributeExpression attributeExpression) {
        this.visitPropertyExpression((PropertyExpression)attributeExpression);
        this.replaceVisitedExpressionWith((Expression)attributeExpression);
    }

    public void visitRegexExpression(RegexExpression regexExpression) {
        RegexExpression regexExpression2 = new RegexExpression(this.replaceExpr(regexExpression.getRegex()));
        regexExpression2.setType(regexExpression.getType());
        regexExpression2.setSourcePosition((ASTNode)regexExpression);
        this.replaceVisitedExpressionWith((Expression)regexExpression2);
    }

    public void visitGStringExpression(GStringExpression gStringExpression) {
        this.replaceAllExprs(gStringExpression.getStrings());
        this.replaceAllExprs(gStringExpression.getValues());
    }

    public void visitArgumentlistExpression(ArgumentListExpression argumentListExpression) {
        this.visitTupleExpression((TupleExpression)argumentListExpression);
        this.replaceVisitedExpressionWith((Expression)argumentListExpression);
    }

    public void visitClosureListExpression(ClosureListExpression closureListExpression) {
        this.visitListExpression((ListExpression)closureListExpression);
        this.replaceVisitedExpressionWith((Expression)closureListExpression);
    }

    public void visitAssertStatement(AssertStatement assertStatement) {
        this.replaceExpr((Expression)assertStatement.getBooleanExpression());
        this.replaceExpr(assertStatement.getMessageExpression());
    }

    public void visitExpressionStatement(ExpressionStatement expressionStatement) {
        this.replaceExpr(expressionStatement.getExpression());
    }

    public void visitReturnStatement(ReturnStatement returnStatement) {
        this.replaceExpr(returnStatement.getExpression());
    }

    public void visitThrowStatement(ThrowStatement throwStatement) {
        this.replaceExpr(throwStatement.getExpression());
    }

    protected void visitListOfExpressions(List list) {
        throw new UnsupportedOperationException("visitListOfExpressions");
    }

    public void visitBreakStatement(BreakStatement breakStatement) {
    }

    public void visitContinueStatement(ContinueStatement continueStatement) {
    }

    public void visitConstantExpression(ConstantExpression constantExpression) {
    }

    public void visitClassExpression(ClassExpression classExpression) {
    }

    public void visitVariableExpression(VariableExpression variableExpression) {
    }

    public void visitFieldExpression(FieldExpression fieldExpression) {
    }

    public void visitBytecodeExpression(BytecodeExpression bytecodeExpression) {
    }
}

