/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.Method;
import org.spockframework.util.UnreachableCodeError;
import spock.lang.Shared;

public class InstanceFieldAccessChecker
extends ClassCodeVisitorSupport {
    private final IRewriteResources resources;

    public InstanceFieldAccessChecker(IRewriteResources iRewriteResources) {
        this.resources = iRewriteResources;
    }

    public void check(Expression expression) {
        expression.visit((GroovyCodeVisitor)this);
    }

    public void check(Method method) {
        for (Block block : method.getBlocks()) {
            for (Statement statement : (List)block.getAst()) {
                statement.visit((GroovyCodeVisitor)this);
            }
        }
    }

    public void visitVariableExpression(VariableExpression variableExpression) {
        super.visitVariableExpression(variableExpression);
        Variable variable = variableExpression.getAccessedVariable();
        if (!(variable instanceof FieldNode)) {
            return;
        }
        this.checkFieldAccess((ASTNode)variableExpression, (FieldNode)variable);
    }

    public void visitFieldExpression(FieldExpression fieldExpression) {
        super.visitFieldExpression(fieldExpression);
        this.checkFieldAccess((ASTNode)fieldExpression, fieldExpression.getField());
    }

    protected SourceUnit getSourceUnit() {
        throw new UnreachableCodeError();
    }

    private void checkFieldAccess(ASTNode aSTNode, FieldNode fieldNode) {
        if (AstUtil.hasAnnotation((ASTNode)fieldNode, Shared.class) || fieldNode.isStatic()) {
            return;
        }
        this.resources.getErrorReporter().error(aSTNode, "Only @Shared and static fields may be accessed from here", new Object[0]);
    }
}

