/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.lang.Wildcard;
import org.spockframework.util.Assert;

public class InteractionRewriter {
    private final IRewriteResources resources;
    private ExpressionStatement stat;
    private Expression count;
    private Expression call;
    private boolean wildcardCall;
    private List<InteractionResult> results = new ArrayList<InteractionResult>();
    private Expression builderExpr;

    public InteractionRewriter(IRewriteResources iRewriteResources) {
        this.resources = iRewriteResources;
    }

    public Statement rewrite(ExpressionStatement expressionStatement) {
        try {
            if (!this.parse(expressionStatement)) {
                return null;
            }
            this.createBuilder();
            this.setCount();
            this.setCall();
            this.addResults();
            this.build();
            return this.register();
        }
        catch (InvalidSpecCompileException invalidSpecCompileException) {
            this.resources.getErrorReporter().error(invalidSpecCompileException);
            return null;
        }
    }

    private boolean parse(ExpressionStatement expressionStatement) throws InvalidSpecCompileException {
        this.stat = expressionStatement;
        Expression expression = this.parseCount(this.parseResults(expressionStatement.getExpression()));
        return (this.count != null || !this.results.isEmpty()) && this.parseCall(expression);
    }

    private Expression parseResults(Expression expression) {
        BinaryExpression binaryExpression;
        int n;
        while (expression instanceof BinaryExpression && ((n = (binaryExpression = (BinaryExpression)expression).getOperation().getType()) == 281 || n == 282)) {
            this.results.add(new InteractionResult(binaryExpression.getRightExpression(), n == 282));
            expression = binaryExpression.getLeftExpression();
        }
        return expression;
    }

    private Expression parseCount(Expression expression) {
        BinaryExpression binaryExpression = AstUtil.asInstance(expression, BinaryExpression.class);
        if (binaryExpression == null || binaryExpression.getOperation().getType() != 202) {
            return expression;
        }
        this.count = binaryExpression.getLeftExpression();
        return binaryExpression.getRightExpression();
    }

    private boolean parseCall(Expression expression) throws InvalidSpecCompileException {
        this.call = expression;
        if (AstUtil.isWildcardRef(expression)) {
            this.wildcardCall = true;
            return true;
        }
        if (expression instanceof PropertyExpression) {
            PropertyExpression propertyExpression = (PropertyExpression)expression;
            if (propertyExpression.isImplicitThis()) {
                return false;
            }
            if (propertyExpression.isStatic()) {
                this.staticMembersNotSupported(expression);
            }
            if (propertyExpression.getObjectExpression() instanceof ClassExpression) {
                this.staticMembersNotSupported(expression);
            }
            return true;
        }
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression methodCallExpression = (MethodCallExpression)expression;
            if (methodCallExpression.isImplicitThis()) {
                return false;
            }
            if (methodCallExpression.getObjectExpression() instanceof ClassExpression) {
                this.staticMembersNotSupported(expression);
            }
            return true;
        }
        if (expression instanceof StaticMethodCallExpression) {
            return false;
        }
        return false;
    }

    private void staticMembersNotSupported(Expression expression) throws InvalidSpecCompileException {
        throw new InvalidSpecCompileException((ASTNode)expression, "Stubbing/mocking of static methods and properties is not supported.", new Object[0]);
    }

    private void createBuilder() {
        Expression expression = this.stat.getExpression();
        this.builderExpr = new ConstructorCallExpression(this.resources.getAstNodeCache().InteractionBuilder, (Expression)new ArgumentListExpression(Arrays.asList(new ConstantExpression((Object)expression.getLineNumber()), new ConstantExpression((Object)expression.getColumnNumber()), new ConstantExpression((Object)this.resources.getSourceText((ASTNode)expression)))));
    }

    private void setCount() {
        if (this.count == null) {
            return;
        }
        if (this.count instanceof RangeExpression) {
            RangeExpression rangeExpression = (RangeExpression)this.count;
            this.call("setRangeCount", new Expression[]{rangeExpression.getFrom(), rangeExpression.getTo(), new ConstantExpression((Object)rangeExpression.isInclusive())});
            return;
        }
        this.call("setFixedCount", this.count);
    }

    private void setCall() {
        if (this.wildcardCall) {
            this.call("addEqualMethodName", new Expression[]{new ConstantExpression((Object)Wildcard.INSTANCE.toString())});
        } else if (this.call instanceof PropertyExpression) {
            this.setPropertyCall();
        } else {
            this.setMethodCall();
        }
    }

    private void setPropertyCall() {
        this.setTarget();
        this.setPropertyName();
    }

    private void setPropertyName() {
        Expression expression = ((PropertyExpression)this.call).getProperty();
        String string = this.selectNameConstraint(expression, "addEqualPropertyName", "addRegexPropertyName");
        this.call(string, expression);
    }

    private void setMethodCall() {
        this.setTarget();
        this.setMethodName();
        this.addArgs();
    }

    private void setTarget() {
        this.call("addEqualTarget", AstUtil.getInvocationTarget(this.call));
    }

    private void setMethodName() {
        Expression expression = ((MethodCallExpression)this.call).getMethod();
        String string = this.selectNameConstraint(expression, "addEqualMethodName", "addRegexMethodName");
        this.call(string, expression);
    }

    private String selectNameConstraint(Expression expression, String string, String string2) {
        if (!(expression instanceof ConstantExpression)) {
            return string;
        }
        String string3 = (String)((ConstantExpression)expression).getValue();
        return AstUtil.isJavaIdentifier(string3) ? string : string2;
    }

    private void addArgs() {
        if (this.call instanceof PropertyExpression) {
            return;
        }
        Expression expression = ((MethodCallExpression)this.call).getArguments();
        if (expression == ArgumentListExpression.EMPTY_ARGUMENTS) {
            return;
        }
        this.call("setArgListKind", new Expression[]{new ConstantExpression((Object)(expression instanceof ArgumentListExpression))});
        if (expression instanceof ArgumentListExpression) {
            this.addPositionalArgs((ArgumentListExpression)expression);
        } else if (expression instanceof NamedArgumentListExpression) {
            this.addNamedArgs((NamedArgumentListExpression)expression);
        } else {
            Assert.that(false, "unknown kind of argument list: " + expression, new Object[0]);
        }
    }

    private void addPositionalArgs(ArgumentListExpression argumentListExpression) {
        for (Expression expression : argumentListExpression.getExpressions()) {
            this.addArg(expression);
        }
    }

    private void addNamedArgs(NamedArgumentListExpression namedArgumentListExpression) {
        for (MapEntryExpression mapEntryExpression : namedArgumentListExpression.getMapEntryExpressions()) {
            this.addName(mapEntryExpression.getKeyExpression());
            this.addArg(mapEntryExpression.getValueExpression());
        }
    }

    private void addName(Expression expression) {
        this.call("addArgName", expression);
    }

    private void addArg(Expression expression) {
        if (expression instanceof NotExpression) {
            NotExpression notExpression = (NotExpression)expression;
            this.addArg(notExpression.getExpression());
            this.call("negateLastArg", new Expression[0]);
            return;
        }
        if (expression instanceof CastExpression) {
            CastExpression castExpression = (CastExpression)expression;
            this.addArg(castExpression.getExpression());
            this.call("typeLastArg", new Expression[]{new ClassExpression(castExpression.getType())});
            return;
        }
        if (expression instanceof ClosureExpression) {
            this.call("addCodeArg", expression);
            return;
        }
        this.call("addEqualArg", expression);
    }

    private void addResults() {
        for (InteractionResult interactionResult : this.results) {
            if (interactionResult.iterable) {
                this.call("setIterableResult", interactionResult.expr);
                continue;
            }
            if (interactionResult.expr instanceof ClosureExpression) {
                this.call("setCodeResult", interactionResult.expr);
                continue;
            }
            this.call("setConstantResult", interactionResult.expr);
        }
    }

    private void build() {
        this.call("build", new Expression[0]);
    }

    private Statement register() {
        ExpressionStatement expressionStatement = new ExpressionStatement((Expression)new MethodCallExpression((Expression)this.resources.getMockControllerRef(), "addInteraction", (Expression)new ArgumentListExpression(this.builderExpr)));
        expressionStatement.setSourcePosition((ASTNode)this.stat);
        return expressionStatement;
    }

    private void call(String string, Expression ... expressionArray) {
        this.builderExpr = new MethodCallExpression(this.builderExpr, string, (Expression)new ArgumentListExpression(expressionArray));
    }

    private static class InteractionResult {
        final Expression expr;
        final boolean iterable;

        private InteractionResult(Expression expression, boolean bl) {
            this.expr = expression;
            this.iterable = bl;
        }
    }
}

