/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;

public class SourceLookup {
    private final SourceUnit sourceUnit;
    private final Janitor janitor = new Janitor();

    public SourceLookup(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    public String lookup(ASTNode aSTNode) {
        String string = "";
        for (int i = aSTNode.getLineNumber(); i <= aSTNode.getLastLineNumber(); ++i) {
            String string2 = this.sourceUnit.getSample(i, 0, this.janitor);
            if (string2 == null) {
                return null;
            }
            try {
                if (i == aSTNode.getLastLineNumber()) {
                    string2 = string2.substring(0, aSTNode.getLastColumnNumber() - 1);
                }
                if (i == aSTNode.getLineNumber()) {
                    string2 = string2.substring(aSTNode.getColumnNumber() - 1);
                }
                string = string + string2;
                if (i == aSTNode.getLastLineNumber()) continue;
                string = string + '\n';
                continue;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return null;
            }
        }
        return string.trim();
    }

    public void close() {
        this.janitor.cleanup();
    }
}

