/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.io.File;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.spockframework.compiler.AbstractSpecVisitor;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.CleanupBlock;
import org.spockframework.compiler.model.ExpectBlock;
import org.spockframework.compiler.model.FeatureMethod;
import org.spockframework.compiler.model.Field;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.SetupBlock;
import org.spockframework.compiler.model.Spec;
import org.spockframework.compiler.model.ThenBlock;
import org.spockframework.compiler.model.WhenBlock;
import org.spockframework.compiler.model.WhereBlock;
import org.spockframework.runtime.model.BlockKind;

public class SpecAnnotator
extends AbstractSpecVisitor {
    private final AstNodeCache nodeCache;
    private ListExpression blockAnnElems;

    public SpecAnnotator(AstNodeCache astNodeCache) {
        this.nodeCache = astNodeCache;
    }

    public void visitSpec(Spec spec) throws Exception {
        this.addSpecMetadata(spec);
    }

    private void addSpecMetadata(Spec spec) {
        AnnotationNode annotationNode = new AnnotationNode(this.nodeCache.SpecMetadata);
        String string = ((ClassNode)spec.getAst()).getModule().getContext().getName();
        String string2 = new File(string).getName();
        annotationNode.setMember("filename", (Expression)new ConstantExpression((Object)string2));
        annotationNode.setMember("line", (Expression)new ConstantExpression((Object)((ClassNode)spec.getAst()).getLineNumber()));
        ((ClassNode)spec.getAst()).addAnnotation(annotationNode);
    }

    public void visitField(Field field) throws Exception {
        this.addFieldMetadata(field);
    }

    private void addFieldMetadata(Field field) {
        AnnotationNode annotationNode = new AnnotationNode(this.nodeCache.FieldMetadata);
        annotationNode.setMember("name", (Expression)new ConstantExpression((Object)field.getName()));
        annotationNode.setMember("ordinal", (Expression)new ConstantExpression((Object)field.getOrdinal()));
        annotationNode.setMember("line", (Expression)new ConstantExpression((Object)((FieldNode)field.getAst()).getLineNumber()));
        ((FieldNode)field.getAst()).addAnnotation(annotationNode);
    }

    public void visitMethod(Method method) throws Exception {
        if (method instanceof FeatureMethod) {
            this.addFeatureMetadata((FeatureMethod)method);
        }
    }

    private void addFeatureMetadata(FeatureMethod featureMethod) {
        AnnotationNode annotationNode = new AnnotationNode(this.nodeCache.FeatureMetadata);
        annotationNode.setMember("name", (Expression)new ConstantExpression((Object)featureMethod.getName()));
        annotationNode.setMember("ordinal", (Expression)new ConstantExpression((Object)featureMethod.getOrdinal()));
        annotationNode.setMember("line", (Expression)new ConstantExpression((Object)((MethodNode)featureMethod.getAst()).getLineNumber()));
        this.blockAnnElems = new ListExpression();
        annotationNode.setMember("blocks", (Expression)this.blockAnnElems);
        ListExpression listExpression = new ListExpression();
        for (Parameter parameter : ((MethodNode)featureMethod.getAst()).getParameters()) {
            listExpression.addExpression((Expression)new ConstantExpression((Object)parameter.getName()));
        }
        annotationNode.setMember("parameterNames", (Expression)listExpression);
        ((MethodNode)featureMethod.getAst()).addAnnotation(annotationNode);
    }

    private void addBlockMetadata(Block block, BlockKind blockKind) {
        AnnotationNode annotationNode = new AnnotationNode(this.nodeCache.BlockMetadata);
        annotationNode.setMember("kind", (Expression)new PropertyExpression((Expression)new ClassExpression(this.nodeCache.BlockKind), blockKind.name()));
        ListExpression listExpression = new ListExpression();
        for (String string : block.getDescriptions()) {
            listExpression.addExpression((Expression)new ConstantExpression((Object)string));
        }
        annotationNode.setMember("texts", (Expression)listExpression);
        this.blockAnnElems.addExpression((Expression)new AnnotationConstantExpression(annotationNode));
    }

    public void visitSetupBlock(SetupBlock setupBlock) throws Exception {
        this.addBlockMetadata(setupBlock, BlockKind.SETUP);
    }

    public void visitExpectBlock(ExpectBlock expectBlock) throws Exception {
        this.addBlockMetadata(expectBlock, BlockKind.EXPECT);
    }

    public void visitWhenBlock(WhenBlock whenBlock) throws Exception {
        this.addBlockMetadata(whenBlock, BlockKind.WHEN);
    }

    public void visitThenBlock(ThenBlock thenBlock) throws Exception {
        this.addBlockMetadata(thenBlock, BlockKind.THEN);
    }

    public void visitCleanupBlock(CleanupBlock cleanupBlock) throws Exception {
        this.addBlockMetadata(cleanupBlock, BlockKind.CLEANUP);
    }

    public void visitWhereBlock(WhereBlock whereBlock) throws Exception {
        this.addBlockMetadata(whereBlock, BlockKind.WHERE);
    }
}

