/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ErrorReporter;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.compiler.model.AnonymousBlock;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.BlockParseInfo;
import org.spockframework.compiler.model.FeatureMethod;
import org.spockframework.compiler.model.Field;
import org.spockframework.compiler.model.FixtureMethod;
import org.spockframework.compiler.model.HelperMethod;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.Spec;
import org.spockframework.util.Identifiers;
import spock.lang.Shared;

public class SpecParser
implements GroovyClassVisitor {
    private final ErrorReporter errorReporter;
    private Spec spec;
    private int fieldCount = 0;
    private int featureMethodCount = 0;

    public SpecParser(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public Spec build(ClassNode classNode) {
        this.spec = new Spec(classNode);
        classNode.visitContents((GroovyClassVisitor)this);
        return this.spec;
    }

    public void visitClass(ClassNode classNode) {
        throw new UnsupportedOperationException("visitClass");
    }

    public void visitField(FieldNode fieldNode) {
        PropertyNode propertyNode = ((ClassNode)this.spec.getAst()).getProperty(fieldNode.getName());
        if (fieldNode.isStatic()) {
            return;
        }
        Field field = new Field(this.spec, fieldNode, this.fieldCount++);
        field.setShared(AstUtil.hasAnnotation((ASTNode)fieldNode, Shared.class));
        field.setOwner(propertyNode);
        this.spec.getFields().add(field);
    }

    public void visitProperty(PropertyNode propertyNode) {
    }

    public void visitConstructor(ConstructorNode constructorNode) {
        if (AstUtil.isSynthetic((MethodNode)constructorNode)) {
            return;
        }
        if (this.constructorMayHaveBeenAddedByCompiler(constructorNode)) {
            return;
        }
        this.errorReporter.error((ASTNode)constructorNode, "Constructors are not allowed; instead, define a 'setup()' or 'setupSpec()' method", new Object[0]);
    }

    private boolean constructorMayHaveBeenAddedByCompiler(ConstructorNode constructorNode) {
        Parameter[] parameterArray = constructorNode.getParameters();
        Statement statement = constructorNode.getFirstStatement();
        return AstUtil.isJointCompiled((ClassNode)this.spec.getAst()) && constructorNode.isPublic() && parameterArray != null && parameterArray.length == 0 && statement == null;
    }

    public void visitMethod(MethodNode methodNode) {
        if (this.isIgnoredMethod(methodNode)) {
            return;
        }
        if (this.isFixtureMethod(methodNode)) {
            this.buildFixtureMethod(methodNode);
        } else if (this.isFeatureMethod(methodNode)) {
            this.buildFeatureMethod(methodNode);
        } else {
            this.buildHelperMethod(methodNode);
        }
    }

    private boolean isIgnoredMethod(MethodNode methodNode) {
        return AstUtil.isSynthetic(methodNode);
    }

    private boolean isFixtureMethod(MethodNode methodNode) {
        String string = methodNode.getName();
        for (String string2 : Identifiers.FIXTURE_METHODS) {
            if (!string2.equalsIgnoreCase(string)) continue;
            if (methodNode.isStatic()) {
                this.errorReporter.error((ASTNode)methodNode, "Fixture methods must not be static", new Object[0]);
            }
            if (!string2.equals(string)) {
                this.errorReporter.error((ASTNode)methodNode, "Misspelled '%s()' method (wrong capitalization)", string2);
            }
            return true;
        }
        return false;
    }

    private void buildFixtureMethod(MethodNode methodNode) {
        FixtureMethod fixtureMethod = new FixtureMethod(this.spec, methodNode);
        AnonymousBlock anonymousBlock = new AnonymousBlock(fixtureMethod);
        fixtureMethod.addBlock(anonymousBlock);
        List<Statement> list = AstUtil.getStatements(methodNode);
        ((List)anonymousBlock.getAst()).addAll(list);
        list.clear();
        String string = methodNode.getName();
        if (string.equals("setup")) {
            this.spec.setSetupMethod(fixtureMethod);
        } else if (string.equals("cleanup")) {
            this.spec.setCleanupMethod(fixtureMethod);
        } else if (string.equals("setupSpec")) {
            this.spec.setSetupSpecMethod(fixtureMethod);
        } else {
            this.spec.setCleanupSpecMethod(fixtureMethod);
        }
    }

    private boolean isFeatureMethod(MethodNode methodNode) {
        for (Statement statement : AstUtil.getStatements(methodNode)) {
            String string = statement.getStatementLabel();
            if (string == null) continue;
            if (methodNode.isStatic()) {
                this.errorReporter.error((ASTNode)methodNode, "Feature methods must not be static", new Object[0]);
            }
            return true;
        }
        return false;
    }

    private void buildFeatureMethod(MethodNode methodNode) {
        FeatureMethod featureMethod = new FeatureMethod(this.spec, methodNode, this.featureMethodCount++);
        try {
            this.buildBlocks(featureMethod);
        }
        catch (InvalidSpecCompileException invalidSpecCompileException) {
            this.errorReporter.error(invalidSpecCompileException);
            return;
        }
        this.spec.getMethods().add(featureMethod);
    }

    private void buildHelperMethod(MethodNode methodNode) {
        HelperMethod helperMethod = new HelperMethod(this.spec, methodNode);
        this.spec.getMethods().add(helperMethod);
        Block block = helperMethod.addBlock(new AnonymousBlock(helperMethod));
        List<Statement> list = AstUtil.getStatements(methodNode);
        ((List)block.getAst()).addAll(list);
        list.clear();
    }

    private void buildBlocks(Method method) throws InvalidSpecCompileException {
        List<Statement> list = AstUtil.getStatements((MethodNode)method.getAst());
        Block block = method.addBlock(new AnonymousBlock(method));
        for (Statement statement : list) {
            if (statement.getStatementLabel() == null) {
                ((List)block.getAst()).add(statement);
                continue;
            }
            block = this.addBlock(method, statement);
        }
        this.checkIsValidSuccessor(method, BlockParseInfo.METHOD_END, ((MethodNode)method.getAst()).getLastLineNumber(), ((MethodNode)method.getAst()).getLastColumnNumber());
        list.clear();
    }

    private Block addBlock(Method method, Statement statement) throws InvalidSpecCompileException {
        String string = statement.getStatementLabel();
        for (BlockParseInfo blockParseInfo : BlockParseInfo.values()) {
            if (!string.equals(blockParseInfo.toString())) continue;
            this.checkIsValidSuccessor(method, blockParseInfo, statement.getLineNumber(), statement.getColumnNumber());
            Block block = blockParseInfo.addNewBlock(method);
            String string2 = this.getDescription(statement);
            if (string2 == null) {
                ((List)block.getAst()).add(statement);
            } else {
                block.getDescriptions().add(string2);
            }
            return block;
        }
        throw new InvalidSpecCompileException((ASTNode)statement, "Unrecognized block label: " + string, new Object[0]);
    }

    private String getDescription(Statement statement) {
        ConstantExpression constantExpression = AstUtil.getExpression(statement, ConstantExpression.class);
        return constantExpression == null || !(constantExpression.getValue() instanceof String) ? null : (String)constantExpression.getValue();
    }

    private void checkIsValidSuccessor(Method method, BlockParseInfo blockParseInfo, int n, int n2) throws InvalidSpecCompileException {
        BlockParseInfo blockParseInfo2 = method.getLastBlock().getParseInfo();
        if (!blockParseInfo2.getSuccessors(method).contains((Object)blockParseInfo)) {
            throw new InvalidSpecCompileException(n, n2, "'%s' is not allowed here; instead, use one of: %s", new Object[]{blockParseInfo, blockParseInfo2.getSuccessors(method), method.getName(), blockParseInfo2, blockParseInfo});
        }
    }
}

