/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;
import org.spockframework.compiler.AbstractSpecVisitor;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ConditionRewriter;
import org.spockframework.compiler.DeepStatementRewriter;
import org.spockframework.compiler.ErrorReporter;
import org.spockframework.compiler.FieldInitializationExpression;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.InstanceFieldAccessChecker;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.compiler.OldValueExpression;
import org.spockframework.compiler.SourceLookup;
import org.spockframework.compiler.WhereBlockRewriter;
import org.spockframework.compiler.model.AnonymousBlock;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.CleanupBlock;
import org.spockframework.compiler.model.ExpectBlock;
import org.spockframework.compiler.model.FeatureMethod;
import org.spockframework.compiler.model.Field;
import org.spockframework.compiler.model.FixtureMethod;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.Spec;
import org.spockframework.compiler.model.ThenBlock;
import org.spockframework.compiler.model.WhenBlock;
import org.spockframework.compiler.model.WhereBlock;
import org.spockframework.util.InternalIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecRewriter
extends AbstractSpecVisitor
implements IRewriteResources {
    private final AstNodeCache nodeCache;
    private final SourceLookup lookup;
    private final ErrorReporter errorReporter;
    private Spec spec;
    private int specDepth;
    private Method method;
    private Block block;
    private VariableExpression thrownExceptionRef;
    private VariableExpression mockControllerRef;
    private VariableExpression sharedInstanceRef;
    private boolean methodHasCondition;
    private boolean movedStatsBackToMethod;
    private boolean thenBlockHasExceptionCondition;
    private int fieldInitializerCount = 0;
    private int sharedFieldInitializerCount = 0;
    private int oldValueCount = 0;

    public SpecRewriter(AstNodeCache astNodeCache, SourceLookup sourceLookup, ErrorReporter errorReporter) {
        this.nodeCache = astNodeCache;
        this.lookup = sourceLookup;
        this.errorReporter = errorReporter;
    }

    @Override
    public void visitSpec(Spec spec) {
        this.spec = spec;
        this.specDepth = this.computeDepth((ClassNode)spec.getAst());
        this.createThrownExceptionFieldAndRef();
        this.createMockControllerFieldAndRef();
        this.createSharedInstanceFieldAndRef();
    }

    private int computeDepth(ClassNode classNode) {
        if (classNode.equals((Object)ClassHelper.OBJECT_TYPE) || classNode.equals((Object)this.nodeCache.Specification)) {
            return -1;
        }
        return this.computeDepth(classNode.getSuperClass()) + 1;
    }

    @Override
    public void visitSpecAgain(Spec spec) throws Exception {
        this.addMockControllerFieldInitializer();
    }

    private void createThrownExceptionFieldAndRef() {
        Object object = this.isDirectlyExtendingSpecification() ? ((ClassNode)this.spec.getAst()).addField("$spock_thrown", 4100, ClassHelper.DYNAMIC_TYPE, null) : new DynamicVariable("$spock_thrown", false);
        this.thrownExceptionRef = new VariableExpression((Variable)object);
    }

    private void createMockControllerFieldAndRef() {
        Object object = this.isDirectlyExtendingSpecification() ? ((ClassNode)this.spec.getAst()).addField("$spock_mockController", 4100, ClassHelper.DYNAMIC_TYPE, null) : new DynamicVariable("$spock_mockController", false);
        this.mockControllerRef = new VariableExpression((Variable)object);
    }

    private void createSharedInstanceFieldAndRef() {
        Object object = this.isDirectlyExtendingSpecification() ? ((ClassNode)this.spec.getAst()).addField("$spock_sharedInstance", 4097, ClassHelper.DYNAMIC_TYPE, null) : new DynamicVariable("$spock_sharedInstance", false);
        this.sharedInstanceRef = new VariableExpression((Variable)object);
    }

    private void addMockControllerFieldInitializer() {
        if (!this.isDirectlyExtendingSpecification()) {
            return;
        }
        this.getInitializerMethod().getStatements().add(0, (Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)this.mockControllerRef, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new ConstructorCallExpression(this.nodeCache.MockController, (Expression)new FieldExpression(this.nodeCache.DefaultMockFactory_INSTANCE)))));
    }

    private boolean isDirectlyExtendingSpecification() {
        ClassNode classNode = ((ClassNode)this.spec.getAst()).getSuperClass();
        return classNode.equals((Object)ClassHelper.OBJECT_TYPE) || classNode.equals((Object)this.nodeCache.Specification);
    }

    @Override
    public void visitField(Field field) {
        if (field.isShared()) {
            this.handleSharedField(field);
        } else {
            this.handleNonSharedField(field);
        }
    }

    private void handleSharedField(Field field) {
        this.changeSharedFieldInternalName(field);
        this.createSharedFieldGetter(field);
        this.createSharedFieldSetter(field);
        this.moveSharedFieldInitializer(field);
        SpecRewriter.makeSharedFieldProtectedAndVolatile(field);
    }

    private void changeSharedFieldInternalName(Field field) {
        ((FieldNode)field.getAst()).rename(InternalIdentifiers.getSharedFieldName(field.getName()));
    }

    private void createSharedFieldGetter(Field field) {
        String string = "get" + MetaClassHelper.capitalize((String)field.getName());
        MethodNode methodNode = ((ClassNode)this.spec.getAst()).getMethod(string, Parameter.EMPTY_ARRAY);
        if (methodNode != null) {
            this.errorReporter.error((ASTNode)field.getAst(), "@Shared field '%s' conflicts with method '%s'; please rename either of them", field.getName(), methodNode.getName());
            return;
        }
        BlockStatement blockStatement = new BlockStatement();
        methodNode = new MethodNode(string, this.determineVisibilityForSharedFieldAccessor(field) | 0x1000, ClassHelper.DYNAMIC_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)blockStatement);
        blockStatement.addStatement((Statement)new ReturnStatement(new ExpressionStatement((Expression)new AttributeExpression((Expression)this.sharedInstanceRef, (Expression)new ConstantExpression((Object)((FieldNode)field.getAst()).getName())))));
        methodNode.setSourcePosition((ASTNode)field.getAst());
        ((ClassNode)this.spec.getAst()).addMethod(methodNode);
    }

    private void createSharedFieldSetter(Field field) {
        String string = "set" + MetaClassHelper.capitalize((String)field.getName());
        Parameter[] parameterArray = new Parameter[]{new Parameter(((FieldNode)field.getAst()).getType(), "$spock_value")};
        MethodNode methodNode = ((ClassNode)this.spec.getAst()).getMethod(string, parameterArray);
        if (methodNode != null) {
            this.errorReporter.error((ASTNode)field.getAst(), "@Shared field '%s' conflicts with method '%s'; please rename either of them", field.getName(), methodNode.getName());
            return;
        }
        BlockStatement blockStatement = new BlockStatement();
        methodNode = new MethodNode(string, this.determineVisibilityForSharedFieldAccessor(field) | 0x1000, ClassHelper.VOID_TYPE, parameterArray, ClassNode.EMPTY_ARRAY, (Statement)blockStatement);
        blockStatement.addStatement((Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)new AttributeExpression((Expression)this.sharedInstanceRef, (Expression)new ConstantExpression((Object)((FieldNode)field.getAst()).getName())), Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new VariableExpression("$spock_value"))));
        methodNode.setSourcePosition((ASTNode)field.getAst());
        ((ClassNode)this.spec.getAst()).addMethod(methodNode);
    }

    private int determineVisibilityForSharedFieldAccessor(Field field) {
        if (field.getOwner() == null) {
            int n = AstUtil.getVisibility((FieldNode)field.getAst());
            if (n == 2) {
                n = 4;
            }
            return n;
        }
        return 1;
    }

    private void moveSharedFieldInitializer(Field field) {
        if (((FieldNode)field.getAst()).getInitialValueExpression() != null) {
            this.moveInitializer(field, this.getSharedInitializerMethod(), this.sharedFieldInitializerCount++);
        }
    }

    private static void makeSharedFieldProtectedAndVolatile(Field field) {
        AstUtil.setVisibility((FieldNode)field.getAst(), 4);
        ((FieldNode)field.getAst()).setModifiers(((FieldNode)field.getAst()).getModifiers() | 0x40);
    }

    private void handleNonSharedField(Field field) {
        if (((FieldNode)field.getAst()).getInitialValueExpression() != null) {
            this.moveInitializer(field, this.getInitializerMethod(), this.fieldInitializerCount++);
        }
    }

    private void moveInitializer(Field field, Method method, int n) {
        ((List)method.getFirstBlock().getAst()).add(n, new ExpressionStatement((Expression)new FieldInitializationExpression((FieldNode)field.getAst())));
        ((FieldNode)field.getAst()).setInitialValueExpression(null);
    }

    @Override
    public void visitMethod(Method method) {
        this.method = method;
        this.methodHasCondition = false;
        this.movedStatsBackToMethod = false;
        if (method instanceof FixtureMethod) {
            this.checkFieldAccessInFixtureMethod(method);
            AstUtil.setVisibility((MethodNode)method.getAst(), 2);
        } else if (method instanceof FeatureMethod) {
            this.transplantMethod(method);
            this.handleWhereBlock(method);
        }
    }

    private void checkFieldAccessInFixtureMethod(Method method) {
        if (method != this.spec.getSetupSpecMethod() && method != this.spec.getCleanupSpecMethod()) {
            return;
        }
        new InstanceFieldAccessChecker(this).check(method);
    }

    private void transplantMethod(Method method) {
        FeatureMethod featureMethod = (FeatureMethod)method;
        MethodNode methodNode = (MethodNode)featureMethod.getAst();
        MethodNode methodNode2 = this.copyMethod(methodNode, this.createInternalName(featureMethod));
        ((ClassNode)this.spec.getAst()).addMethod(methodNode2);
        featureMethod.setAst(methodNode2);
        AstUtil.deleteMethod((ClassNode)this.spec.getAst(), methodNode);
    }

    private String createInternalName(FeatureMethod featureMethod) {
        return String.format("$spock_feature_%d_%d", this.specDepth, featureMethod.getOrdinal());
    }

    private MethodNode copyMethod(MethodNode methodNode, String string) {
        MethodNode methodNode2 = new MethodNode(string, methodNode.getModifiers(), ClassHelper.VOID_TYPE, methodNode.getParameters(), methodNode.getExceptions(), methodNode.getCode());
        methodNode2.addAnnotations(methodNode.getAnnotations());
        methodNode2.setSynthetic(methodNode.isSynthetic());
        methodNode2.setDeclaringClass(methodNode.getDeclaringClass());
        methodNode2.setSourcePosition((ASTNode)methodNode);
        methodNode2.setVariableScope(methodNode.getVariableScope());
        methodNode2.setGenericsTypes(methodNode.getGenericsTypes());
        methodNode2.setAnnotationDefault(methodNode.hasAnnotationDefault());
        return methodNode2;
    }

    private void handleWhereBlock(Method method) {
        Block block = method.getLastBlock();
        if (!(block instanceof WhereBlock)) {
            Parameter[] parameterArray = ((MethodNode)method.getAst()).getParameters();
            if (parameterArray.length > 0) {
                this.errorReporter.error((ASTNode)parameterArray[0], "Feature methods without 'where' block may not declare parameters", new Object[0]);
            }
            return;
        }
        new DeepStatementRewriter(this).visitBlock(block);
        WhereBlockRewriter.rewrite((WhereBlock)block, this);
    }

    @Override
    public void visitMethodAgain(Method method) {
        this.block = null;
        if (this.methodHasCondition) {
            this.defineValueRecorder(method.getStatements());
        }
        if (!this.movedStatsBackToMethod) {
            for (Block block : method.getBlocks()) {
                method.getStatements().addAll((Collection)block.getAst());
            }
        }
        if (method instanceof FeatureMethod) {
            method.getStatements().add(this.createMockControllerCall("leaveScope"));
        }
    }

    @Override
    public void visitAnyBlock(Block block) {
        this.block = block;
        if (block instanceof ExpectBlock || block instanceof ThenBlock) {
            return;
        }
        DeepStatementRewriter deepStatementRewriter = new DeepStatementRewriter(this);
        deepStatementRewriter.visitBlock(block);
        this.methodHasCondition |= deepStatementRewriter.isConditionFound();
    }

    @Override
    public void visitExpectBlock(ExpectBlock expectBlock) {
        ListIterator<Statement> listIterator = ((List)expectBlock.getAst()).listIterator();
        while (listIterator.hasNext()) {
            Statement statement = (Statement)listIterator.next();
            DeepStatementRewriter deepStatementRewriter = new DeepStatementRewriter(this);
            Statement statement2 = deepStatementRewriter.replace(statement);
            this.methodHasCondition |= deepStatementRewriter.isConditionFound();
            if (statement instanceof AssertStatement) {
                listIterator.set(statement2);
                continue;
            }
            if (this.isExceptionCondition(statement2)) {
                this.errorReporter.error((ASTNode)statement2, "Exception conditions are only allowed in 'then' blocks", new Object[0]);
                continue;
            }
            if (this.statHasInteraction(statement2, deepStatementRewriter)) {
                this.errorReporter.error((ASTNode)statement2, "Interactions are only allowed in 'then' blocks", new Object[0]);
                continue;
            }
            if (!this.isImplicitCondition(statement2)) continue;
            this.checkIsValidCondition(statement2);
            listIterator.set(this.rewriteImplicitCondition(statement2));
            this.methodHasCondition = true;
        }
    }

    @Override
    public void visitThenBlock(ThenBlock thenBlock) {
        ListIterator<Statement> listIterator = ((List)thenBlock.getAst()).listIterator();
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        if (thenBlock.isFirstInChain()) {
            this.thenBlockHasExceptionCondition = false;
        }
        while (listIterator.hasNext()) {
            Statement statement = (Statement)listIterator.next();
            DeepStatementRewriter deepStatementRewriter = new DeepStatementRewriter(this);
            Statement statement2 = deepStatementRewriter.replace(statement);
            this.methodHasCondition |= deepStatementRewriter.isConditionFound();
            if (statement instanceof AssertStatement) {
                listIterator.set(statement2);
                continue;
            }
            if (this.isExceptionCondition(statement2)) {
                this.rewriteExceptionCondition(statement2);
                if (this.thenBlockHasExceptionCondition) continue;
                this.rewriteWhenBlockForExceptionCondition(thenBlock.getPrevious(WhenBlock.class));
                this.thenBlockHasExceptionCondition = true;
                continue;
            }
            if (this.statHasInteraction(statement2, deepStatementRewriter)) {
                arrayList.add(statement2);
                listIterator.remove();
                continue;
            }
            if (!this.isImplicitCondition(statement2)) continue;
            this.checkIsValidCondition(statement2);
            listIterator.set(this.rewriteImplicitCondition(statement2));
            this.methodHasCondition = true;
        }
        this.insertInteractions(arrayList, thenBlock);
    }

    private boolean isImplicitCondition(Statement statement) {
        return statement instanceof ExpressionStatement && !(((ExpressionStatement)statement).getExpression() instanceof DeclarationExpression);
    }

    private void checkIsValidCondition(Statement statement) {
        BinaryExpression binaryExpression = AstUtil.getExpression(statement, BinaryExpression.class);
        if (binaryExpression == null) {
            return;
        }
        if (Types.ofType((int)binaryExpression.getOperation().getType(), (int)1100)) {
            this.errorReporter.error((ASTNode)statement, "Expected a condition, but found an assignment. Did you intend to write '==' ?", new Object[0]);
        }
    }

    private Statement rewriteImplicitCondition(Statement statement) {
        return ConditionRewriter.rewriteImplicitCondition((ExpressionStatement)statement, this);
    }

    private boolean isExceptionCondition(Statement statement) {
        Expression expression = AstUtil.getExpression(statement, Expression.class);
        return expression != null && AstUtil.isBuiltinMemberAssignmentOrCall(expression, "thrown", 0, 1);
    }

    private void rewriteExceptionCondition(Statement statement) {
        if (this.thenBlockHasExceptionCondition) {
            this.errorReporter.error((ASTNode)statement, "A 'then' block may only have one exception condition", new Object[0]);
            return;
        }
        Expression expression = AstUtil.getExpression(statement, Expression.class);
        assert (expression != null);
        try {
            AstUtil.expandBuiltinMemberAssignmentOrCall(expression, new Expression[]{this.thrownExceptionRef});
        }
        catch (InvalidSpecCompileException invalidSpecCompileException) {
            this.errorReporter.error(invalidSpecCompileException);
        }
    }

    private boolean statHasInteraction(Statement statement, DeepStatementRewriter deepStatementRewriter) {
        if (deepStatementRewriter.isInteractionFound()) {
            return true;
        }
        Expression expression = AstUtil.getExpression(statement, Expression.class);
        return expression != null && AstUtil.isBuiltinMemberCall(expression, "interaction", 0, 1);
    }

    private void insertInteractions(List<Statement> list, ThenBlock thenBlock) {
        if (list.isEmpty()) {
            return;
        }
        List list2 = (List)thenBlock.getPrevious(WhenBlock.class).getPrevious().getAst();
        list2.add(this.createMockControllerCall(thenBlock.isFirstInChain() ? "enterScope" : "addBarrier"));
        list2.addAll(list);
        if (thenBlock.isFirstInChain()) {
            ((List)thenBlock.getAst()).add(0, this.createMockControllerCall("leaveScope"));
        }
    }

    private Statement createMockControllerCall(String string) {
        return new ExpressionStatement((Expression)new MethodCallExpression((Expression)this.mockControllerRef, string, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
    }

    @Override
    public void visitCleanupBlock(CleanupBlock cleanupBlock) {
        Block block2;
        for (Block arrayList2 : this.method.getBlocks()) {
            if (arrayList2 == cleanupBlock) break;
            SpecRewriter.moveVariableDeclarations((List)arrayList2.getAst(), this.method.getStatements());
        }
        ArrayList arrayList3 = new ArrayList();
        for (Block block2 : this.method.getBlocks()) {
            if (block2 == cleanupBlock) break;
            arrayList3.addAll((Collection)block2.getAst());
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll((Collection)cleanupBlock.getAst());
        block2 = new TryCatchStatement((Statement)new BlockStatement((List)arrayList3, new VariableScope()), (Statement)new BlockStatement(arrayList, new VariableScope()));
        this.method.getStatements().add((Statement)block2);
        this.movedStatsBackToMethod = true;
    }

    @Override
    public Spec getCurrentSpec() {
        return this.spec;
    }

    @Override
    public Method getCurrentMethod() {
        return this.method;
    }

    @Override
    public Block getCurrentBlock() {
        return this.block;
    }

    @Override
    public void defineValueRecorder(List<Statement> list) {
        list.add(0, (Statement)new ExpressionStatement((Expression)new DeclarationExpression(new VariableExpression("$spock_valueRecorder"), Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new ConstructorCallExpression(this.nodeCache.ValueRecorder, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS))));
    }

    @Override
    public VariableExpression captureOldValue(Expression expression) {
        OldValueExpression oldValueExpression = new OldValueExpression(expression, "$spock_oldValue" + this.oldValueCount++);
        DeclarationExpression declarationExpression = new DeclarationExpression((VariableExpression)oldValueExpression, Token.newSymbol((int)100, (int)-1, (int)-1), expression);
        declarationExpression.setSourcePosition((ASTNode)expression);
        ((List)this.block.getPrevious().getPrevious().getAst()).add(new ExpressionStatement((Expression)declarationExpression));
        return oldValueExpression;
    }

    @Override
    public VariableExpression getMockControllerRef() {
        return this.mockControllerRef;
    }

    @Override
    public AstNodeCache getAstNodeCache() {
        return this.nodeCache;
    }

    private FixtureMethod getInitializerMethod() {
        if (this.spec.getInitializerMethod() == null) {
            MethodNode methodNode = new MethodNode("$spock_initializeFields", 4098, ClassHelper.DYNAMIC_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)new BlockStatement());
            ((ClassNode)this.spec.getAst()).addMethod(methodNode);
            FixtureMethod fixtureMethod = new FixtureMethod(this.spec, methodNode);
            fixtureMethod.addBlock(new AnonymousBlock(fixtureMethod));
            this.spec.setInitializerMethod(fixtureMethod);
        }
        return this.spec.getInitializerMethod();
    }

    @Override
    public String getSourceText(ASTNode aSTNode) {
        return this.lookup.lookup(aSTNode);
    }

    @Override
    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    private FixtureMethod getSharedInitializerMethod() {
        if (this.spec.getSharedInitializerMethod() == null) {
            MethodNode methodNode = new MethodNode("$spock_initializeSharedFields", 4098, ClassHelper.DYNAMIC_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)new BlockStatement());
            ((ClassNode)this.spec.getAst()).addMethod(methodNode);
            FixtureMethod fixtureMethod = new FixtureMethod(this.spec, methodNode);
            fixtureMethod.addBlock(new AnonymousBlock(fixtureMethod));
            this.spec.setSharedInitializerMethod(fixtureMethod);
        }
        return this.spec.getSharedInitializerMethod();
    }

    private void rewriteWhenBlockForExceptionCondition(WhenBlock whenBlock) {
        List list = (List)whenBlock.getAst();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        whenBlock.setAst(arrayList);
        arrayList.add(new ExpressionStatement((Expression)new BinaryExpression((Expression)this.thrownExceptionRef, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)ConstantExpression.NULL)));
        SpecRewriter.moveVariableDeclarations(list, this.method.getStatements());
        TryCatchStatement tryCatchStatement = new TryCatchStatement((Statement)new BlockStatement(list, new VariableScope()), (Statement)new BlockStatement());
        arrayList.add(tryCatchStatement);
        tryCatchStatement.addCatch(new CatchStatement(new Parameter(this.nodeCache.Throwable, "$spock_ex"), (Statement)new BlockStatement(Arrays.asList(new ExpressionStatement((Expression)new BinaryExpression((Expression)this.thrownExceptionRef, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new VariableExpression("$spock_ex")))), new VariableScope())));
    }

    private static void moveVariableDeclarations(List<Statement> list, List<Statement> list2) {
        for (Statement statement : list) {
            ExpressionStatement expressionStatement;
            if (!(statement instanceof ExpressionStatement) || !((expressionStatement = (ExpressionStatement)statement).getExpression() instanceof DeclarationExpression)) continue;
            DeclarationExpression declarationExpression = (DeclarationExpression)expressionStatement.getExpression();
            expressionStatement.setExpression((Expression)new BinaryExpression((Expression)new VariableExpression(declarationExpression.getVariableExpression().getName()), Token.newSymbol((int)100, (int)-1, (int)-1), declarationExpression.getRightExpression()));
            declarationExpression.setRightExpression((Expression)ConstantExpression.NULL);
            list2.add((Statement)new ExpressionStatement((Expression)declarationExpression));
        }
    }
}

