/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.compiler.ErrorReporter;
import org.spockframework.compiler.SourceLookup;
import org.spockframework.compiler.SpecAnnotator;
import org.spockframework.compiler.SpecParser;
import org.spockframework.compiler.SpecRewriter;
import org.spockframework.compiler.model.Spec;
import org.spockframework.util.VersionChecker;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class SpockTransform
implements ASTTransformation {
    public SpockTransform() {
        VersionChecker.checkGroovyVersion("compiler plugin");
    }

    public void visit(ASTNode[] aSTNodeArray, SourceUnit sourceUnit) {
        new Impl().visit(aSTNodeArray, sourceUnit);
    }

    private static class Impl {
        static final AstNodeCache nodeCache = new AstNodeCache();

        private Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void visit(ASTNode[] aSTNodeArray, SourceUnit sourceUnit) {
            ErrorReporter errorReporter = new ErrorReporter(sourceUnit);
            SourceLookup sourceLookup = new SourceLookup(sourceUnit);
            try {
                ModuleNode moduleNode = (ModuleNode)aSTNodeArray[0];
                List list = moduleNode.getClasses();
                for (ClassNode classNode : list) {
                    if (!this.isSpec(classNode)) continue;
                    this.processSpec(classNode, errorReporter, sourceLookup);
                }
            }
            finally {
                sourceLookup.close();
            }
        }

        boolean isSpec(ClassNode classNode) {
            return classNode.isDerivedFrom(Impl.nodeCache.Specification);
        }

        void processSpec(ClassNode classNode, ErrorReporter errorReporter, SourceLookup sourceLookup) {
            try {
                Spec spec = new SpecParser(errorReporter).build(classNode);
                spec.accept(new SpecRewriter(nodeCache, sourceLookup, errorReporter));
                spec.accept(new SpecAnnotator(nodeCache));
            }
            catch (Exception exception) {
                errorReporter.error("Unexpected error during compilation of spec '%s'. Maybe you have used invalid Spock syntax? Anyway, please file a bug report at http://issues.spockframework.org.", exception, classNode.getName());
            }
        }
    }
}

