/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatementReplacingVisitorSupport
extends ClassCodeVisitorSupport {
    private Statement replacement;

    public Statement replace(Statement statement) {
        this.replacement = null;
        statement.visit((GroovyCodeVisitor)this);
        Statement statement2 = this.replacement == null ? statement : this.replacement;
        this.replacement = null;
        return statement2;
    }

    protected <T extends Statement> void replaceAll(List<T> list) {
        ListIterator<T> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.set(this.replace((Statement)listIterator.next()));
        }
    }

    protected void replaceVisitedStatementWith(Statement statement) {
        this.replacement = statement;
    }

    public void visitBlockStatement(BlockStatement blockStatement) {
        this.replaceAll(blockStatement.getStatements());
    }

    public void visitForLoop(ForStatement forStatement) {
        forStatement.getCollectionExpression().visit((GroovyCodeVisitor)this);
        forStatement.setLoopBlock(this.replace(forStatement.getLoopBlock()));
    }

    public void visitWhileLoop(WhileStatement whileStatement) {
        whileStatement.getBooleanExpression().visit((GroovyCodeVisitor)this);
        whileStatement.setLoopBlock(this.replace(whileStatement.getLoopBlock()));
    }

    public void visitDoWhileLoop(DoWhileStatement doWhileStatement) {
        doWhileStatement.getBooleanExpression().visit((GroovyCodeVisitor)this);
        doWhileStatement.setLoopBlock(this.replace(doWhileStatement.getLoopBlock()));
    }

    public void visitIfElse(IfStatement ifStatement) {
        ifStatement.getBooleanExpression().visit((GroovyCodeVisitor)this);
        ifStatement.setIfBlock(this.replace(ifStatement.getIfBlock()));
        ifStatement.setElseBlock(this.replace(ifStatement.getElseBlock()));
    }

    public void visitTryCatchFinally(TryCatchStatement tryCatchStatement) {
        tryCatchStatement.setTryStatement(this.replace(tryCatchStatement.getTryStatement()));
        this.replaceAll(tryCatchStatement.getCatchStatements());
        tryCatchStatement.setFinallyStatement(this.replace(tryCatchStatement.getFinallyStatement()));
    }

    public void visitSwitch(SwitchStatement switchStatement) {
        switchStatement.getExpression().visit((GroovyCodeVisitor)this);
        this.replaceAll(switchStatement.getCaseStatements());
        switchStatement.setDefaultStatement(this.replace(switchStatement.getDefaultStatement()));
    }

    public void visitCaseStatement(CaseStatement caseStatement) {
        caseStatement.getExpression().visit((GroovyCodeVisitor)this);
        caseStatement.setCode(this.replace(caseStatement.getCode()));
    }

    public void visitSynchronizedStatement(SynchronizedStatement synchronizedStatement) {
        synchronizedStatement.getExpression().visit((GroovyCodeVisitor)this);
        synchronizedStatement.setCode(this.replace(synchronizedStatement.getCode()));
    }

    public void visitCatchStatement(CatchStatement catchStatement) {
        catchStatement.setCode(this.replace(catchStatement.getCode()));
    }

    protected SourceUnit getSourceUnit() {
        throw new UnsupportedOperationException("getSourceUnit");
    }
}

