/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.syntax.Token;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.InstanceFieldAccessChecker;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.Spec;
import org.spockframework.compiler.model.WhereBlock;
import org.spockframework.util.InternalIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhereBlockRewriter {
    private final WhereBlock whereBlock;
    private final IRewriteResources resources;
    private final InstanceFieldAccessChecker instanceFieldAccessChecker;
    private int dataProviderCount = 0;
    private final List<Parameter> dataProcessorParams = new ArrayList<Parameter>();
    private final List<Statement> dataProcessorStats = new ArrayList<Statement>();
    private final List<VariableExpression> dataProcessorVars = new ArrayList<VariableExpression>();

    private WhereBlockRewriter(WhereBlock whereBlock, IRewriteResources iRewriteResources) {
        this.whereBlock = whereBlock;
        this.resources = iRewriteResources;
        this.instanceFieldAccessChecker = new InstanceFieldAccessChecker(iRewriteResources);
    }

    public static void rewrite(WhereBlock whereBlock, IRewriteResources iRewriteResources) {
        new WhereBlockRewriter(whereBlock, iRewriteResources).rewrite();
    }

    private void rewrite() {
        ListIterator<Statement> listIterator = ((List)this.whereBlock.getAst()).listIterator();
        while (listIterator.hasNext()) {
            try {
                this.rewriteWhereStat(listIterator);
            }
            catch (InvalidSpecCompileException invalidSpecCompileException) {
                this.resources.getErrorReporter().error(invalidSpecCompileException);
            }
        }
        ((List)this.whereBlock.getAst()).clear();
        this.handleFeatureParameters();
        this.createDataProcessorMethod();
    }

    private void rewriteWhereStat(ListIterator<Statement> listIterator) throws InvalidSpecCompileException {
        int n;
        Statement statement = listIterator.next();
        BinaryExpression binaryExpression = AstUtil.getExpression(statement, BinaryExpression.class);
        if (binaryExpression == null || binaryExpression.getClass() != BinaryExpression.class) {
            WhereBlockRewriter.notAParameterization((ASTNode)statement);
        }
        if ((n = binaryExpression.getOperation().getType()) == 280) {
            Expression expression = binaryExpression.getLeftExpression();
            if (expression instanceof VariableExpression) {
                this.rewriteSimpleParameterization(binaryExpression, (ASTNode)statement);
            } else if (expression instanceof ListExpression) {
                this.rewriteMultiParameterization(binaryExpression, statement);
            } else {
                WhereBlockRewriter.notAParameterization((ASTNode)statement);
            }
        } else if (n == 100) {
            this.rewriteDerivedParameterization(binaryExpression, statement);
        } else if (this.getOrExpression((Expression)binaryExpression) != null) {
            listIterator.previous();
            this.rewriteTableLikeParameterization(listIterator);
        } else {
            WhereBlockRewriter.notAParameterization((ASTNode)statement);
        }
    }

    private void createDataProviderMethod(Expression expression, int n) {
        this.instanceFieldAccessChecker.check(expression);
        MethodNode methodNode = new MethodNode(InternalIdentifiers.getDataProviderName(((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getName(), this.dataProviderCount++), 4097, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)new BlockStatement(Arrays.asList(new ReturnStatement(new ExpressionStatement(expression))), new VariableScope()));
        methodNode.addAnnotation(this.createDataProviderAnnotation(expression, n));
        ((ClassNode)((Spec)((Method)this.whereBlock.getParent()).getParent()).getAst()).addMethod(methodNode);
    }

    private AnnotationNode createDataProviderAnnotation(Expression expression, int n) {
        AnnotationNode annotationNode = new AnnotationNode(this.resources.getAstNodeCache().DataProviderMetadata);
        annotationNode.addMember("line", (Expression)new ConstantExpression((Object)expression.getLineNumber()));
        ArrayList<ConstantExpression> arrayList = new ArrayList<ConstantExpression>();
        for (int i = n; i < this.dataProcessorVars.size(); ++i) {
            arrayList.add(new ConstantExpression((Object)this.dataProcessorVars.get(i).getName()));
        }
        annotationNode.addMember("dataVariables", (Expression)new ListExpression(arrayList));
        return annotationNode;
    }

    private Parameter createDataProcessorParameter() {
        Parameter parameter = new Parameter(ClassHelper.DYNAMIC_TYPE, "$spock_p" + this.dataProcessorParams.size());
        this.dataProcessorParams.add(parameter);
        return parameter;
    }

    private void rewriteSimpleParameterization(BinaryExpression binaryExpression, ASTNode aSTNode) throws InvalidSpecCompileException {
        int n = this.dataProcessorVars.size();
        Parameter parameter = this.createDataProcessorParameter();
        VariableExpression variableExpression = (VariableExpression)binaryExpression.getLeftExpression();
        VariableExpression variableExpression2 = this.createDataProcessorVariable((Expression)variableExpression, aSTNode);
        ExpressionStatement expressionStatement = new ExpressionStatement((Expression)new DeclarationExpression(variableExpression2, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new VariableExpression((Variable)parameter)));
        expressionStatement.setSourcePosition(aSTNode);
        this.dataProcessorStats.add((Statement)expressionStatement);
        this.createDataProviderMethod(binaryExpression.getRightExpression(), n);
    }

    private void rewriteMultiParameterization(BinaryExpression binaryExpression, Statement statement) throws InvalidSpecCompileException {
        int n = this.dataProcessorVars.size();
        Parameter parameter = this.createDataProcessorParameter();
        ListExpression listExpression = (ListExpression)binaryExpression.getLeftExpression();
        List list = listExpression.getExpressions();
        for (int i = 0; i < list.size(); ++i) {
            Expression expression = (Expression)list.get(i);
            if (AstUtil.isWildcardRef(expression)) continue;
            VariableExpression variableExpression = this.createDataProcessorVariable(expression, (ASTNode)statement);
            ExpressionStatement expressionStatement = new ExpressionStatement((Expression)new DeclarationExpression(variableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new MethodCallExpression((Expression)new VariableExpression((Variable)parameter), "getAt", (Expression)new ConstantExpression((Object)i))));
            expressionStatement.setSourcePosition((ASTNode)statement);
            this.dataProcessorStats.add((Statement)expressionStatement);
        }
        this.createDataProviderMethod(binaryExpression.getRightExpression(), n);
    }

    private void rewriteDerivedParameterization(BinaryExpression binaryExpression, Statement statement) throws InvalidSpecCompileException {
        VariableExpression variableExpression = this.createDataProcessorVariable(binaryExpression.getLeftExpression(), (ASTNode)statement);
        ExpressionStatement expressionStatement = new ExpressionStatement((Expression)new DeclarationExpression(variableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), binaryExpression.getRightExpression()));
        expressionStatement.setSourcePosition((ASTNode)statement);
        this.dataProcessorStats.add((Statement)expressionStatement);
    }

    private void rewriteTableLikeParameterization(ListIterator<Statement> listIterator) throws InvalidSpecCompileException {
        LinkedList<List<Expression>> linkedList = new LinkedList<List<Expression>>();
        while (listIterator.hasNext()) {
            Statement statement = listIterator.next();
            BinaryExpression object = this.getOrExpression(statement);
            if (object == null) {
                listIterator.previous();
                break;
            }
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            this.splitRow((Expression)object, arrayList);
            if (linkedList.size() > 0 && linkedList.getLast().size() != arrayList.size()) {
                throw new InvalidSpecCompileException((ASTNode)statement, String.format("Row in data table has wrong number of elements (%s instead of %s)", arrayList.size(), linkedList.getLast().size()), new Object[0]);
            }
            linkedList.add(arrayList);
        }
        for (List list : this.transposeTable(linkedList)) {
            this.turnIntoSimpleParameterization(list);
        }
    }

    List<List<Expression>> transposeTable(List<List<Expression>> list) {
        ArrayList<List<Expression>> arrayList = new ArrayList<List<Expression>>();
        if (list.isEmpty()) {
            return arrayList;
        }
        for (int i = 0; i < list.get(0).size(); ++i) {
            arrayList.add(new ArrayList());
        }
        for (List<Expression> list2 : list) {
            for (int i = 0; i < list2.size(); ++i) {
                ((List)arrayList.get(i)).add(list2.get(i));
            }
        }
        return arrayList;
    }

    private void turnIntoSimpleParameterization(List<Expression> list) throws InvalidSpecCompileException {
        VariableExpression variableExpression = AstUtil.asInstance(list.get(0), VariableExpression.class);
        if (variableExpression == null) {
            throw new InvalidSpecCompileException((ASTNode)list.get(0), "Header of data table may only contain variable names", new Object[0]);
        }
        ListExpression listExpression = new ListExpression(list.subList(1, list.size()));
        BinaryExpression binaryExpression = new BinaryExpression((Expression)variableExpression, Token.newSymbol((int)280, (int)-1, (int)-1), (Expression)listExpression);
        this.rewriteSimpleParameterization(binaryExpression, (ASTNode)variableExpression);
    }

    private void splitRow(Expression expression, List<Expression> list) {
        BinaryExpression binaryExpression = this.getOrExpression(expression);
        if (binaryExpression == null) {
            list.add(expression);
        } else {
            this.splitRow(binaryExpression.getLeftExpression(), list);
            this.splitRow(binaryExpression.getRightExpression(), list);
        }
    }

    private BinaryExpression getOrExpression(Statement statement) {
        Expression expression = AstUtil.getExpression(statement, Expression.class);
        return this.getOrExpression(expression);
    }

    private BinaryExpression getOrExpression(Expression expression) {
        BinaryExpression binaryExpression = AstUtil.asInstance(expression, BinaryExpression.class);
        if (binaryExpression == null) {
            return null;
        }
        int n = binaryExpression.getOperation().getType();
        if (n == 340 || n == 162) {
            return binaryExpression;
        }
        return null;
    }

    private VariableExpression createDataProcessorVariable(Expression expression, ASTNode aSTNode) throws InvalidSpecCompileException {
        if (!(expression instanceof VariableExpression)) {
            WhereBlockRewriter.notAParameterization(aSTNode);
        }
        VariableExpression variableExpression = (VariableExpression)expression;
        this.verifyDataProcessorVariable(variableExpression);
        VariableExpression variableExpression2 = new VariableExpression(variableExpression.getName(), variableExpression.getType());
        this.dataProcessorVars.add(variableExpression2);
        return variableExpression2;
    }

    private void verifyDataProcessorVariable(VariableExpression variableExpression) {
        Variable variable = variableExpression.getAccessedVariable();
        if (variable instanceof VariableExpression) {
            this.resources.getErrorReporter().error((ASTNode)variableExpression, "A variable named '%s' already exists in this scope", variableExpression.getName());
            return;
        }
        if (this.getDataProcessorVariable(variableExpression.getName()) != null) {
            this.resources.getErrorReporter().error((ASTNode)variableExpression, "Duplicate declaration of data variable '%s'", variableExpression.getName());
            return;
        }
        if (((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getParameters().length > 0 && !(variable instanceof Parameter)) {
            this.resources.getErrorReporter().error((ASTNode)variableExpression, "Data variable '%s' needs to be declared as method parameter", variableExpression.getName());
        }
    }

    private VariableExpression getDataProcessorVariable(String string) {
        for (VariableExpression variableExpression : this.dataProcessorVars) {
            if (!variableExpression.getName().equals(string)) continue;
            return variableExpression;
        }
        return null;
    }

    private void handleFeatureParameters() {
        Parameter[] parameterArray = ((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getParameters();
        if (parameterArray.length == 0) {
            this.addFeatureParameters();
        } else {
            this.checkAllParametersAreDataVariables(parameterArray);
        }
    }

    private void checkAllParametersAreDataVariables(Parameter[] parameterArray) {
        for (Parameter parameter : parameterArray) {
            if (this.getDataProcessorVariable(parameter.getName()) != null) continue;
            this.resources.getErrorReporter().error((ASTNode)parameter, "Parameter '%s' does not refer to a data variable", parameter.getName());
        }
    }

    private void addFeatureParameters() {
        Parameter[] parameterArray = new Parameter[this.dataProcessorVars.size()];
        for (int i = 0; i < this.dataProcessorVars.size(); ++i) {
            parameterArray[i] = new Parameter(ClassHelper.DYNAMIC_TYPE, this.dataProcessorVars.get(i).getName());
        }
        ((MethodNode)((Method)this.whereBlock.getParent()).getAst()).setParameters(parameterArray);
    }

    private void createDataProcessorMethod() {
        if (this.dataProcessorVars.isEmpty()) {
            return;
        }
        this.dataProcessorStats.add((Statement)new ReturnStatement((Expression)new ArrayExpression(ClassHelper.OBJECT_TYPE, this.dataProcessorVars)));
        ((ClassNode)((Spec)((Method)this.whereBlock.getParent()).getParent()).getAst()).addMethod(new MethodNode(InternalIdentifiers.getDataProcessorName(((MethodNode)((Method)this.whereBlock.getParent()).getAst()).getName()), 4097, ClassHelper.OBJECT_TYPE, this.dataProcessorParams.toArray(new Parameter[this.dataProcessorParams.size()]), ClassNode.EMPTY_ARRAY, (Statement)new BlockStatement(this.dataProcessorStats, new VariableScope())));
    }

    private static void notAParameterization(ASTNode aSTNode) throws InvalidSpecCompileException {
        throw new InvalidSpecCompileException(aSTNode, "where-blocks may only contain parameterizations (e.g. 'salary << [1000, 5000, 9000]; salaryk = salary / 1000')", new Object[0]);
    }
}

