/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.model.BlockParseInfo;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Block
extends Node<Method, List<Statement>> {
    private final List<String> descriptions = new ArrayList<String>(3);
    private Block prev;
    private Block next;

    public Block(Method method) {
        super(method, new ArrayList());
    }

    public List<String> getDescriptions() {
        return this.descriptions;
    }

    public Block getPrevious() {
        return this.prev;
    }

    public void setPrevious(Block block) {
        this.prev = block;
    }

    public Block getNext() {
        return this.next;
    }

    public void setNext(Block block) {
        this.next = block;
    }

    public <T extends Block> T getPrevious(Class<T> clazz) {
        Block block = this.prev;
        while (block != null && !clazz.isInstance(block)) {
            block = block.prev;
        }
        return (T)((Block)clazz.cast(block));
    }

    public <T extends Block> T getNext(Class<T> clazz) {
        Block block = this.next;
        while (block != null && !clazz.isInstance(block)) {
            block = block.next;
        }
        return (T)((Block)clazz.cast(block));
    }

    public boolean isFirst() {
        return this.prev == null;
    }

    public boolean isLast() {
        return this.next == null;
    }

    public boolean isFirstInChain() {
        return this.isFirst() || this.getClass() != this.prev.getClass();
    }

    public abstract BlockParseInfo getParseInfo();
}

