/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.spockframework.compiler.model.Field;
import org.spockframework.compiler.model.FixtureMethod;
import org.spockframework.compiler.model.ISpecVisitor;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spec
extends Node<Spec, ClassNode> {
    private final List<Field> fields = new ArrayList<Field>();
    private final List<Method> methods = new ArrayList<Method>();
    private FixtureMethod initializerMethod;
    private FixtureMethod sharedInitializerMethod;
    private FixtureMethod setupMethod;
    private FixtureMethod cleanupMethod;
    private FixtureMethod setupSpecMethod;
    private FixtureMethod cleanupSpecMethod;

    public Spec(ClassNode classNode) {
        super(null, classNode);
        this.setName(classNode.getName());
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public FixtureMethod getInitializerMethod() {
        return this.initializerMethod;
    }

    public void setInitializerMethod(FixtureMethod fixtureMethod) {
        this.initializerMethod = fixtureMethod;
        this.methods.add(fixtureMethod);
    }

    public FixtureMethod getSharedInitializerMethod() {
        return this.sharedInitializerMethod;
    }

    public void setSharedInitializerMethod(FixtureMethod fixtureMethod) {
        this.sharedInitializerMethod = fixtureMethod;
        this.methods.add(fixtureMethod);
    }

    public FixtureMethod getSetupMethod() {
        return this.setupMethod;
    }

    public void setSetupMethod(FixtureMethod fixtureMethod) {
        this.setupMethod = fixtureMethod;
        this.methods.add(fixtureMethod);
    }

    public FixtureMethod getCleanupMethod() {
        return this.cleanupMethod;
    }

    public void setCleanupMethod(FixtureMethod fixtureMethod) {
        this.cleanupMethod = fixtureMethod;
        this.methods.add(fixtureMethod);
    }

    public FixtureMethod getSetupSpecMethod() {
        return this.setupSpecMethod;
    }

    public void setSetupSpecMethod(FixtureMethod fixtureMethod) {
        this.setupSpecMethod = fixtureMethod;
        this.methods.add(fixtureMethod);
    }

    public FixtureMethod getCleanupSpecMethod() {
        return this.cleanupSpecMethod;
    }

    public void setCleanupSpecMethod(FixtureMethod fixtureMethod) {
        this.cleanupSpecMethod = fixtureMethod;
        this.methods.add(fixtureMethod);
    }

    @Override
    public void accept(ISpecVisitor iSpecVisitor) throws Exception {
        iSpecVisitor.visitSpec(this);
        for (Field node : this.fields) {
            node.accept(iSpecVisitor);
        }
        for (Method method : this.methods) {
            method.accept(iSpecVisitor);
        }
        iSpecVisitor.visitSpecAgain(this);
    }
}

