/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.gentyref;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spockframework.gentyref.CaptureType;
import org.spockframework.gentyref.VarMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CaptureTypeImpl
implements CaptureType {
    private final WildcardType wildcard;
    private final TypeVariable<?> variable;
    private final Type[] lowerBounds;
    private Type[] upperBounds;

    public CaptureTypeImpl(WildcardType wildcardType, TypeVariable<?> typeVariable) {
        this.wildcard = wildcardType;
        this.variable = typeVariable;
        this.lowerBounds = wildcardType.getLowerBounds();
    }

    void init(VarMap varMap) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        arrayList.addAll(Arrays.asList(varMap.map(this.variable.getBounds())));
        List<Type> list = Arrays.asList(this.wildcard.getUpperBounds());
        if (list.size() > 0 && list.get(0) == Object.class) {
            arrayList.addAll(list.subList(1, list.size()));
        } else {
            arrayList.addAll(list);
        }
        this.upperBounds = new Type[arrayList.size()];
        arrayList.toArray(this.upperBounds);
    }

    @Override
    public Type[] getLowerBounds() {
        return (Type[])this.lowerBounds.clone();
    }

    @Override
    public Type[] getUpperBounds() {
        assert (this.upperBounds != null);
        return (Type[])this.upperBounds.clone();
    }

    public String toString() {
        return "capture of " + this.wildcard;
    }
}

