/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.gentyref;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.spockframework.gentyref.CaptureType;
import org.spockframework.gentyref.CaptureTypeImpl;
import org.spockframework.gentyref.GenericArrayTypeImpl;
import org.spockframework.gentyref.ParameterizedTypeImpl;
import org.spockframework.gentyref.VarMap;
import org.spockframework.gentyref.WildcardTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTypeReflector {
    private static final Type UNBOUND_WILDCARD = new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);

    public static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            if (typeVariable.getBounds().length == 0) {
                return Object.class;
            }
            return GenericTypeReflector.erase(typeVariable.getBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return GenericArrayTypeImpl.createArrayType(GenericTypeReflector.erase(genericArrayType.getGenericComponentType()));
        }
        throw new RuntimeException("not supported: " + type.getClass());
    }

    private static Type mapTypeParameters(Type type, Type type2) {
        if (GenericTypeReflector.isMissingTypeParameters(type2)) {
            return GenericTypeReflector.erase(type);
        }
        VarMap varMap = new VarMap();
        Type type3 = type2;
        while (type3 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type3;
            Class clazz = (Class)parameterizedType.getRawType();
            varMap.addAll(clazz.getTypeParameters(), parameterizedType.getActualTypeArguments());
            type3 = parameterizedType.getOwnerType();
        }
        return varMap.map(type);
    }

    private static boolean isMissingTypeParameters(Type type) {
        if (type instanceof Class) {
            for (Class<?> clazz = (Class<?>)type; clazz != null; clazz = clazz.getEnclosingClass()) {
                if (clazz.getTypeParameters().length == 0) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            return false;
        }
        throw new AssertionError((Object)("Unexpected type " + type.getClass()));
    }

    public static Type addWildcardParameters(Class<?> clazz) {
        if (clazz.isArray()) {
            return GenericArrayTypeImpl.createArrayType(GenericTypeReflector.addWildcardParameters(clazz.getComponentType()));
        }
        if (GenericTypeReflector.isMissingTypeParameters(clazz)) {
            TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
            Object[] objectArray = new Type[typeVariableArray.length];
            Arrays.fill(objectArray, UNBOUND_WILDCARD);
            Type type = clazz.getDeclaringClass() == null ? null : GenericTypeReflector.addWildcardParameters(clazz.getDeclaringClass());
            return new ParameterizedTypeImpl(clazz, (Type[])objectArray, type);
        }
        return clazz;
    }

    public static Type getExactSuperType(Type type, Class<?> clazz) {
        if (type instanceof ParameterizedType || type instanceof Class || type instanceof GenericArrayType) {
            Type[] typeArray = GenericTypeReflector.erase(type);
            if (clazz == typeArray) {
                return type;
            }
            if (!clazz.isAssignableFrom((Class<?>)typeArray)) {
                return null;
            }
        }
        for (Type type2 : GenericTypeReflector.getExactDirectSuperTypes(type)) {
            Type type3 = GenericTypeReflector.getExactSuperType(type2, clazz);
            if (type3 == null) continue;
            return type3;
        }
        return null;
    }

    public static Type getTypeParameter(Type type, TypeVariable<? extends Class<?>> typeVariable) {
        Class<?> clazz = typeVariable.getGenericDeclaration();
        Type type2 = GenericTypeReflector.getExactSuperType(type, clazz);
        if (type2 instanceof ParameterizedType) {
            int n = Arrays.asList(clazz.getTypeParameters()).indexOf(typeVariable);
            return ((ParameterizedType)type2).getActualTypeArguments()[n];
        }
        return null;
    }

    public static boolean isSuperType(Type type, Type type2) {
        if (type instanceof ParameterizedType || type instanceof Class || type instanceof GenericArrayType) {
            Class<?> clazz = GenericTypeReflector.erase(type);
            Type type3 = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type2), clazz);
            if (type3 == null) {
                return false;
            }
            if (type instanceof Class) {
                return true;
            }
            if (type3 instanceof Class) {
                return true;
            }
            if (type3 instanceof GenericArrayType) {
                Type type4 = GenericTypeReflector.getArrayComponentType(type);
                assert (type4 != null);
                Type type5 = GenericTypeReflector.getArrayComponentType(type3);
                assert (type5 != null);
                return GenericTypeReflector.isSuperType(type4, type5);
            }
            assert (type3 instanceof ParameterizedType);
            ParameterizedType parameterizedType = (ParameterizedType)type3;
            assert (parameterizedType.getRawType() == clazz);
            ParameterizedType parameterizedType2 = (ParameterizedType)type;
            Type[] typeArray = parameterizedType2.getActualTypeArguments();
            Type[] typeArray2 = parameterizedType.getActualTypeArguments();
            assert (typeArray.length == typeArray2.length);
            for (int i = 0; i < typeArray.length; ++i) {
                if (GenericTypeReflector.contains(typeArray[i], typeArray2[i])) continue;
                return false;
            }
            return parameterizedType2.getOwnerType() == null || GenericTypeReflector.isSuperType(parameterizedType2.getOwnerType(), parameterizedType.getOwnerType());
        }
        if (type instanceof CaptureType) {
            if (type.equals(type2)) {
                return true;
            }
            for (Type type6 : ((CaptureType)type).getLowerBounds()) {
                if (!GenericTypeReflector.isSuperType(type6, type2)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof GenericArrayType) {
            return GenericTypeReflector.isArraySupertype(type, type2);
        }
        throw new RuntimeException("not implemented: " + type.getClass());
    }

    private static boolean isArraySupertype(Type type, Type type2) {
        Type type3 = GenericTypeReflector.getArrayComponentType(type);
        assert (type3 != null);
        Type type4 = GenericTypeReflector.getArrayComponentType(type2);
        if (type4 == null) {
            return false;
        }
        return GenericTypeReflector.isSuperType(type3, type4);
    }

    public static Type getArrayComponentType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.getComponentType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return genericArrayType.getGenericComponentType();
        }
        return null;
    }

    private static boolean contains(Type type, Type type2) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type type3 : wildcardType.getUpperBounds()) {
                if (GenericTypeReflector.isSuperType(type3, type2)) continue;
                return false;
            }
            for (Type type3 : wildcardType.getLowerBounds()) {
                if (GenericTypeReflector.isSuperType(type2, type3)) continue;
                return false;
            }
            return true;
        }
        return type.equals(type2);
    }

    private static Type[] getExactDirectSuperTypes(Type type) {
        if (type instanceof ParameterizedType || type instanceof Class) {
            int n;
            Type[] typeArray;
            Class clazz;
            if (type instanceof ParameterizedType) {
                clazz = (Class)((ParameterizedType)type).getRawType();
            } else {
                clazz = (Class)type;
                if (clazz.isArray()) {
                    return GenericTypeReflector.getArrayExactDirectSuperTypes(clazz);
                }
            }
            Type[] typeArray2 = clazz.getGenericInterfaces();
            Type type2 = clazz.getGenericSuperclass();
            if (type2 == null) {
                typeArray = new Type[typeArray2.length];
                n = 0;
            } else {
                typeArray = new Type[typeArray2.length + 1];
                n = 1;
                typeArray[0] = GenericTypeReflector.mapTypeParameters(type2, type);
            }
            for (Type type3 : typeArray2) {
                typeArray[n++] = GenericTypeReflector.mapTypeParameters(type3, type);
            }
            return typeArray;
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return typeVariable.getBounds();
        }
        if (type instanceof WildcardType) {
            return ((WildcardType)type).getUpperBounds();
        }
        if (type instanceof CaptureType) {
            return ((CaptureType)type).getUpperBounds();
        }
        if (type instanceof GenericArrayType) {
            return GenericTypeReflector.getArrayExactDirectSuperTypes(type);
        }
        throw new RuntimeException("not implemented type: " + type);
    }

    private static Type[] getArrayExactDirectSuperTypes(Type type) {
        Type[] typeArray;
        int n;
        Type type2 = GenericTypeReflector.getArrayComponentType(type);
        if (type2 instanceof Class && ((Class)type2).isPrimitive()) {
            n = 0;
            typeArray = new Type[3];
        } else {
            Type[] typeArray2 = GenericTypeReflector.getExactDirectSuperTypes(type2);
            typeArray = new Type[typeArray2.length + 3];
            for (n = 0; n < typeArray2.length; ++n) {
                typeArray[n] = GenericArrayTypeImpl.createArrayType(typeArray2[n]);
            }
        }
        typeArray[n++] = Object.class;
        typeArray[n++] = Cloneable.class;
        typeArray[n++] = Serializable.class;
        return typeArray;
    }

    public static Type[] getExactParameterTypes(Method method, Type type) {
        Type[] typeArray = method.getGenericParameterTypes();
        Type type2 = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), method.getDeclaringClass());
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = GenericTypeReflector.mapTypeParameters(typeArray[i], type2);
        }
        return typeArray2;
    }

    public static Type getExactReturnType(Method method, Type type) {
        Type type2 = method.getGenericReturnType();
        Type type3 = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), method.getDeclaringClass());
        return GenericTypeReflector.mapTypeParameters(type2, type3);
    }

    public static Type getExactFieldType(Field field, Type type) {
        Type type2 = field.getGenericType();
        Type type3 = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), field.getDeclaringClass());
        return GenericTypeReflector.mapTypeParameters(type2, type3);
    }

    /*
     * WARNING - void declaration
     */
    public static Type capture(Type type) {
        VarMap varMap = new VarMap();
        ArrayList<CaptureTypeImpl> arrayList = new ArrayList<CaptureTypeImpl>();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
            Type[] typeArray2 = new Type[typeArray.length];
            assert (typeArray.length == typeVariableArray.length);
            for (int i = 0; i < typeArray.length; ++i) {
                void type2;
                Type type3 = typeArray[i];
                if (type3 instanceof WildcardType) {
                    CaptureTypeImpl captureTypeImpl;
                    CaptureTypeImpl captureTypeImpl2 = captureTypeImpl = new CaptureTypeImpl((WildcardType)type3, typeVariableArray[i]);
                    arrayList.add(captureTypeImpl);
                }
                typeArray2[i] = type2;
                varMap.add(typeVariableArray[i], (Type)type2);
            }
            for (CaptureTypeImpl captureTypeImpl : arrayList) {
                captureTypeImpl.init(varMap);
            }
            Iterator iterator = parameterizedType.getOwnerType() == null ? null : GenericTypeReflector.capture(parameterizedType.getOwnerType());
            return new ParameterizedTypeImpl(clazz, typeArray2, (Type)((Object)iterator));
        }
        return type;
    }

    public static String getTypeName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() ? GenericTypeReflector.getTypeName(clazz.getComponentType()) + "[]" : clazz.getName();
        }
        return type.toString();
    }

    public static List<Class<?>> getUpperBoundClassAndInterfaces(Type type) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        GenericTypeReflector.buildUpperBoundClassAndInterfaces(type, linkedHashSet);
        return new ArrayList(linkedHashSet);
    }

    private static void buildUpperBoundClassAndInterfaces(Type type, Set<Class<?>> set) {
        if (type instanceof ParameterizedType || type instanceof Class) {
            set.add(GenericTypeReflector.erase(type));
            return;
        }
        for (Type type2 : GenericTypeReflector.getExactDirectSuperTypes(type)) {
            GenericTypeReflector.buildUpperBoundClassAndInterfaces(type2, set);
        }
    }
}

