/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.gentyref;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.spockframework.gentyref.GenericTypeReflector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterizedTypeImpl
implements ParameterizedType {
    private final Class<?> rawType;
    private final Type[] actualTypeArguments;
    private final Type ownerType;

    public ParameterizedTypeImpl(Class<?> clazz, Type[] typeArray, Type type) {
        this.rawType = clazz;
        this.actualTypeArguments = typeArray;
        this.ownerType = type;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)object;
        return this.rawType.equals(parameterizedType.getRawType()) && Arrays.equals(this.actualTypeArguments, parameterizedType.getActualTypeArguments()) && (this.ownerType == null ? parameterizedType.getOwnerType() == null : this.ownerType.equals(parameterizedType.getOwnerType()));
    }

    public int hashCode() {
        int n = this.rawType.hashCode() ^ Arrays.hashCode(this.actualTypeArguments);
        if (this.ownerType != null) {
            n ^= this.ownerType.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.rawType.getName();
        if (this.ownerType != null) {
            String string2;
            stringBuilder.append(GenericTypeReflector.getTypeName(this.ownerType)).append('.');
            String string3 = string2 = this.ownerType instanceof ParameterizedType ? ((Class)((ParameterizedType)this.ownerType).getRawType()).getName() + '$' : ((Class)this.ownerType).getName() + '$';
            if (string.startsWith(string2)) {
                string = string.substring(string2.length());
            }
        }
        stringBuilder.append(string);
        if (this.actualTypeArguments.length != 0) {
            stringBuilder.append('<');
            for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                Type type = this.actualTypeArguments[i];
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(GenericTypeReflector.getTypeName(type));
            }
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }
}

