/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.gentyref;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeToken<T> {
    private final Type type;

    protected TypeToken() {
        this.type = this.extractType();
    }

    private TypeToken(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    private Type extractType() {
        Type type = this.getClass().getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            throw new RuntimeException("Invalid TypeToken; must specify type parameters");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType.getRawType() != TypeToken.class) {
            throw new RuntimeException("Invalid TypeToken; must directly extend TypeToken");
        }
        return parameterizedType.getActualTypeArguments()[0];
    }

    public static <T> TypeToken<T> get(Class<T> clazz) {
        return new SimpleTypeToken(clazz);
    }

    public static TypeToken<?> get(Type type) {
        return new SimpleTypeToken(type);
    }

    public boolean equals(Object object) {
        return object instanceof TypeToken && this.type.equals(((TypeToken)object).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleTypeToken<T>
    extends TypeToken<T> {
        public SimpleTypeToken(Type type) {
            super(type);
        }
    }
}

