/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.gentyref;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.spockframework.gentyref.GenericArrayTypeImpl;
import org.spockframework.gentyref.ParameterizedTypeImpl;
import org.spockframework.gentyref.WildcardTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VarMap {
    private final Map<TypeVariable<?>, Type> map = new HashMap();

    VarMap() {
    }

    void add(TypeVariable<?> typeVariable, Type type) {
        this.map.put(typeVariable, type);
    }

    void addAll(TypeVariable<?>[] typeVariableArray, Type[] typeArray) {
        assert (typeVariableArray.length == typeArray.length);
        for (int i = 0; i < typeVariableArray.length; ++i) {
            this.map.put(typeVariableArray[i], typeArray[i]);
        }
    }

    VarMap(TypeVariable<?>[] typeVariableArray, Type[] typeArray) {
        this.addAll(typeVariableArray, typeArray);
    }

    Type map(Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            assert (this.map.containsKey(type));
            return this.map.get(type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new ParameterizedTypeImpl((Class)parameterizedType.getRawType(), this.map(parameterizedType.getActualTypeArguments()), parameterizedType.getOwnerType() == null ? parameterizedType.getOwnerType() : this.map(parameterizedType.getOwnerType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return new WildcardTypeImpl(this.map(wildcardType.getUpperBounds()), this.map(wildcardType.getLowerBounds()));
        }
        if (type instanceof GenericArrayType) {
            return GenericArrayTypeImpl.createArrayType(this.map(((GenericArrayType)type).getGenericComponentType()));
        }
        throw new RuntimeException("not implemented: mapping " + type.getClass() + " (" + type + ")");
    }

    Type[] map(Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = this.map(typeArray[i]);
        }
        return typeArray2;
    }
}

