/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisException;
import org.objenesis.ObjenesisStd;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.IInvocationDispatcher;
import org.spockframework.mock.IMockFactory;
import org.spockframework.mock.MockInvocation;
import org.spockframework.mock.MockObject;
import org.spockframework.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMockFactory
implements IMockFactory {
    public static final String INSTANCE_FIELD = "INSTANCE";
    public static final DefaultMockFactory INSTANCE = new DefaultMockFactory();
    private static final boolean cglibAvailable = ReflectionUtil.isClassAvailable("net.sf.cglib.proxy.Enhancer");
    private static final boolean objenesisAvailable = ReflectionUtil.isClassAvailable("org.objenesis.Objenesis");

    @Override
    public Object create(String string, Class<?> clazz, IInvocationDispatcher iInvocationDispatcher) {
        if (Modifier.isFinal(clazz.getModifiers())) {
            throw new CannotCreateMockException(clazz, "mocking final classes is not supported.");
        }
        if (clazz.isInterface()) {
            return this.createDynamicProxyMock(string, clazz, iInvocationDispatcher);
        }
        if (cglibAvailable) {
            return CglibMockFactory.create(string, clazz, iInvocationDispatcher);
        }
        throw new CannotCreateMockException(clazz, "by default, only mocking of interfaces is supported; to allow mocking of classes, put cglib-nodep-2.2 or higher on the classpath.");
    }

    private Object createDynamicProxyMock(final String string, final Class<?> clazz, final IInvocationDispatcher iInvocationDispatcher) {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object object, Method method, Object[] objectArray) {
                MockObject mockObject = new MockObject(string, clazz, object);
                MockInvocation mockInvocation = new MockInvocation(mockObject, method, DefaultMockFactory.normalizeArgs(objectArray));
                return iInvocationDispatcher.dispatch(mockInvocation);
            }
        });
    }

    private static List<Object> normalizeArgs(Object[] objectArray) {
        return objectArray == null ? Collections.emptyList() : Arrays.asList(objectArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CglibMockFactory {
        private CglibMockFactory() {
        }

        static Object create(final String string, final Class<?> clazz, final IInvocationDispatcher iInvocationDispatcher) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(clazz);
            final boolean bl = GroovyObject.class.isAssignableFrom(clazz);
            MethodInterceptor methodInterceptor = new MethodInterceptor(){

                public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) {
                    if (bl && CglibMockFactory.isMethod(method, "getMetaClass", 0)) {
                        return GroovySystem.getMetaClassRegistry().getMetaClass(object.getClass());
                    }
                    MockObject mockObject = new MockObject(string, clazz, object);
                    MockInvocation mockInvocation = new MockInvocation(mockObject, method, DefaultMockFactory.normalizeArgs(objectArray));
                    return iInvocationDispatcher.dispatch(mockInvocation);
                }
            };
            if (objenesisAvailable) {
                enhancer.setCallbackType(methodInterceptor.getClass());
                Object object = ObjenesisInstantiator.instantiate(enhancer.createClass());
                ((Factory)object).setCallback(0, (Callback)methodInterceptor);
                return object;
            }
            try {
                enhancer.setCallback((Callback)methodInterceptor);
                return enhancer.create();
            }
            catch (Exception exception) {
                throw new CannotCreateMockException(clazz, "the latter has no parameterless constructor; to allow mocking of classes without parameterless constructor, put objenesis-1.2 or higher on the classpath.");
            }
        }

        private static boolean isMethod(Method method, String string, int n) {
            return method.getName().equals(string) && method.getParameterTypes().length == n;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ObjenesisInstantiator {
            static final Objenesis objenesis = new ObjenesisStd();

            private ObjenesisInstantiator() {
            }

            static Object instantiate(Class<?> clazz) {
                try {
                    return objenesis.newInstance(clazz);
                }
                catch (ObjenesisException objenesisException) {
                    throw new CannotCreateMockException(clazz, (Throwable)objenesisException);
                }
            }
        }
    }
}

