/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import org.spockframework.lang.SpreadWildcard;
import org.spockframework.lang.Wildcard;
import org.spockframework.mock.CodeArgumentConstraint;
import org.spockframework.mock.CodeResultGenerator;
import org.spockframework.mock.ConstantResultGenerator;
import org.spockframework.mock.DefaultResultGenerator;
import org.spockframework.mock.EqualArgumentConstraint;
import org.spockframework.mock.EqualMethodNameConstraint;
import org.spockframework.mock.EqualPropertyNameConstraint;
import org.spockframework.mock.IArgumentConstraint;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IdenticalTargetConstraint;
import org.spockframework.mock.IterableResultGenerator;
import org.spockframework.mock.MockInteraction;
import org.spockframework.mock.NamedArgumentListConstraint;
import org.spockframework.mock.NegatingArgumentConstraint;
import org.spockframework.mock.PositionalArgumentListConstraint;
import org.spockframework.mock.RegexMethodNameConstraint;
import org.spockframework.mock.RegexPropertyNameConstraint;
import org.spockframework.mock.ResultGeneratorChain;
import org.spockframework.mock.SpreadWildcardArgumentConstraint;
import org.spockframework.mock.TypeArgumentConstraint;
import org.spockframework.mock.WildcardArgumentConstraint;
import org.spockframework.mock.WildcardMethodNameConstraint;
import org.spockframework.runtime.InvalidSpecException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionBuilder {
    private final int line;
    private final int column;
    private final String text;
    private int minCount = 0;
    private int maxCount = Integer.MAX_VALUE;
    private List<IInvocationConstraint> invConstraints = new ArrayList<IInvocationConstraint>();
    private List<Object> argNames;
    private List<IArgumentConstraint> argConstraints;
    private ResultGeneratorChain resultGenerators = new ResultGeneratorChain();
    public static final String SET_FIXED_COUNT = "setFixedCount";
    public static final String SET_RANGE_COUNT = "setRangeCount";
    public static final String ADD_EQUAL_TARGET = "addEqualTarget";
    public static final String ADD_EQUAL_PROPERTY_NAME = "addEqualPropertyName";
    public static final String ADD_REGEX_PROPERTY_NAME = "addRegexPropertyName";
    public static final String ADD_EQUAL_METHOD_NAME = "addEqualMethodName";
    public static final String ADD_REGEX_METHOD_NAME = "addRegexMethodName";
    public static final String SET_ARG_LIST_KIND = "setArgListKind";
    public static final String ADD_ARG_NAME = "addArgName";
    public static final String ADD_CODE_ARG = "addCodeArg";
    public static final String ADD_EQUAL_ARG = "addEqualArg";
    public static final String TYPE_LAST_ARG = "typeLastArg";
    public static final String NEGATE_LAST_ARG = "negateLastArg";
    public static final String ADD_CONSTANT_RESULT = "setConstantResult";
    public static final String ADD_CODE_RESULT = "setCodeResult";
    public static final String ADD_ITERABLE_RESULT = "setIterableResult";
    public static final String BUILD = "build";

    public InteractionBuilder(int n, int n2, String string) {
        this.line = n;
        this.column = n2;
        this.text = string;
    }

    public InteractionBuilder setFixedCount(Object object) {
        if (object instanceof Wildcard) {
            this.minCount = 0;
            this.maxCount = Integer.MAX_VALUE;
        } else {
            this.minCount = this.maxCount = InteractionBuilder.convertCount(object, true);
        }
        return this;
    }

    public InteractionBuilder setRangeCount(Object object, Object object2, boolean bl) {
        this.minCount = object instanceof Wildcard ? 0 : InteractionBuilder.convertCount(object, true);
        int n = this.maxCount = object2 instanceof Wildcard ? Integer.MAX_VALUE : InteractionBuilder.convertCount(object2, bl);
        if (this.minCount > this.maxCount) {
            throw new InvalidSpecException("lower bound of invocation count must come before upper bound");
        }
        return this;
    }

    public InteractionBuilder addEqualTarget(Object object) {
        if (!(object instanceof Wildcard)) {
            this.invConstraints.add(new IdenticalTargetConstraint(object));
        }
        return this;
    }

    public InteractionBuilder addEqualPropertyName(String string) {
        if (string.equals(Wildcard.INSTANCE.toString())) {
            this.invConstraints.add(WildcardMethodNameConstraint.INSTANCE);
        } else {
            this.invConstraints.add(new EqualPropertyNameConstraint(string));
        }
        return this;
    }

    public InteractionBuilder addRegexPropertyName(String string) {
        this.invConstraints.add(new RegexPropertyNameConstraint(string));
        return this;
    }

    public InteractionBuilder addEqualMethodName(String string) {
        if (string.equals(Wildcard.INSTANCE.toString())) {
            this.invConstraints.add(WildcardMethodNameConstraint.INSTANCE);
        } else {
            this.invConstraints.add(new EqualMethodNameConstraint(string));
        }
        return this;
    }

    public InteractionBuilder addRegexMethodName(String string) {
        this.invConstraints.add(new RegexMethodNameConstraint(string));
        return this;
    }

    public InteractionBuilder setArgListKind(boolean bl) {
        this.argConstraints = new ArrayList<IArgumentConstraint>();
        if (bl) {
            this.invConstraints.add(new PositionalArgumentListConstraint(this.argConstraints));
        } else {
            this.argNames = new ArrayList<Object>();
            this.invConstraints.add(new NamedArgumentListConstraint(this.argNames, this.argConstraints));
        }
        return this;
    }

    public InteractionBuilder addArgName(String string) {
        this.argNames.add(string);
        return this;
    }

    public InteractionBuilder addCodeArg(Closure closure) {
        this.argConstraints.add(new CodeArgumentConstraint(closure));
        return this;
    }

    public InteractionBuilder addEqualArg(Object object) {
        this.argConstraints.add(object instanceof Wildcard ? WildcardArgumentConstraint.INSTANCE : (object instanceof SpreadWildcard ? SpreadWildcardArgumentConstraint.INSTANCE : new EqualArgumentConstraint(object)));
        return this;
    }

    public InteractionBuilder typeLastArg(Class<?> clazz) {
        IArgumentConstraint iArgumentConstraint = this.argConstraints.get(this.argConstraints.size() - 1);
        this.argConstraints.set(this.argConstraints.size() - 1, new TypeArgumentConstraint(clazz, iArgumentConstraint));
        return this;
    }

    public InteractionBuilder negateLastArg() {
        IArgumentConstraint iArgumentConstraint = this.argConstraints.get(this.argConstraints.size() - 1);
        this.argConstraints.set(this.argConstraints.size() - 1, new NegatingArgumentConstraint(iArgumentConstraint));
        return this;
    }

    public InteractionBuilder setConstantResult(Object object) {
        this.resultGenerators.addFirst(object instanceof Wildcard ? new DefaultResultGenerator() : new ConstantResultGenerator(object));
        return this;
    }

    public InteractionBuilder setCodeResult(Closure closure) {
        this.resultGenerators.addFirst(new CodeResultGenerator(closure));
        return this;
    }

    public InteractionBuilder setIterableResult(Object object) {
        this.resultGenerators.addFirst(new IterableResultGenerator(object));
        return this;
    }

    public IMockInteraction build() {
        if (this.resultGenerators.isEmpty()) {
            this.resultGenerators.addFirst(new DefaultResultGenerator());
        }
        return new MockInteraction(this.line, this.column, this.text, this.minCount, this.maxCount, this.invConstraints, this.resultGenerators);
    }

    private static int convertCount(Object object, boolean bl) {
        if (!(object instanceof Number)) {
            throw new InvalidSpecException("invocation count must be a number");
        }
        int n = ((Number)object).intValue();
        if (!bl) {
            --n;
        }
        if (n < 0) {
            throw new InvalidSpecException("invocation count must be >= 0");
        }
        return n;
    }
}

