/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import java.util.ArrayList;
import java.util.List;
import org.spockframework.mock.IInteractionScope;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.MockInteractionDecorator;
import org.spockframework.mock.TooFewInvocationsError;
import org.spockframework.mock.WrongInvocationOrderError;

public class InteractionScope
implements IInteractionScope {
    private final List<IMockInteraction> interactions = new ArrayList<IMockInteraction>();
    private int currentRegistrationZone = 0;
    private int currentExecutionZone = 0;

    public void addInteraction(IMockInteraction iMockInteraction) {
        this.interactions.add(new MockInteractionDecorator(iMockInteraction){
            final int myRegistrationZone;
            {
                this.myRegistrationZone = InteractionScope.this.currentRegistrationZone;
            }

            public Object accept(IMockInvocation iMockInvocation) {
                Object object = super.accept(iMockInvocation);
                if (InteractionScope.this.currentExecutionZone > this.myRegistrationZone) {
                    throw new WrongInvocationOrderError(this.decorated, iMockInvocation);
                }
                InteractionScope.this.currentExecutionZone = this.myRegistrationZone;
                return object;
            }
        });
    }

    public void addOrderingBarrier() {
        ++this.currentRegistrationZone;
    }

    public IMockInteraction match(IMockInvocation iMockInvocation) {
        for (IMockInteraction iMockInteraction : this.interactions) {
            if (!iMockInteraction.matches(iMockInvocation)) continue;
            return iMockInteraction;
        }
        return null;
    }

    public void verifyInteractions() {
        ArrayList<IMockInteraction> arrayList = new ArrayList<IMockInteraction>();
        for (IMockInteraction iMockInteraction : this.interactions) {
            if (iMockInteraction.isSatisfied()) continue;
            arrayList.add(iMockInteraction);
        }
        if (!arrayList.isEmpty()) {
            throw new TooFewInvocationsError(arrayList);
        }
    }
}

