/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.spockframework.mock.DefaultInteractionScope;
import org.spockframework.mock.IInteractionScope;
import org.spockframework.mock.IInvocationDispatcher;
import org.spockframework.mock.IMockFactory;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.InteractionNotSatisfiedError;
import org.spockframework.mock.InteractionScope;
import org.spockframework.util.InternalSpockError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockController
implements IInvocationDispatcher {
    private final IMockFactory factory;
    private final LinkedList<IInteractionScope> scopes = new LinkedList();
    private final List<InteractionNotSatisfiedError> errors = new ArrayList<InteractionNotSatisfiedError>();
    public static final String ADD_INTERACTION = "addInteraction";
    public static final String ADD_BARRIER = "addBarrier";
    public static final String ENTER_SCOPE = "enterScope";
    public static final String LEAVE_SCOPE = "leaveScope";

    public MockController(IMockFactory iMockFactory) {
        this.factory = iMockFactory;
        this.scopes.addFirst(DefaultInteractionScope.INSTANCE);
        this.scopes.addFirst(new InteractionScope());
    }

    @Override
    public synchronized Object dispatch(IMockInvocation iMockInvocation) {
        for (IInteractionScope iInteractionScope : this.scopes) {
            IMockInteraction iMockInteraction = iInteractionScope.match(iMockInvocation);
            if (iMockInteraction == null) continue;
            try {
                return iMockInteraction.accept(iMockInvocation);
            }
            catch (InteractionNotSatisfiedError interactionNotSatisfiedError) {
                this.errors.add(interactionNotSatisfiedError);
                throw interactionNotSatisfiedError;
            }
        }
        throw new InternalSpockError("No interaction matched invocation: %s").withArgs(iMockInvocation);
    }

    public synchronized void addInteraction(IMockInteraction iMockInteraction) {
        this.scopes.getFirst().addInteraction(iMockInteraction);
    }

    public synchronized void addBarrier() {
        this.scopes.getFirst().addOrderingBarrier();
    }

    public synchronized void enterScope() {
        this.throwAnyPreviousError();
        this.scopes.addFirst(new InteractionScope());
    }

    public synchronized void leaveScope() {
        this.throwAnyPreviousError();
        IInteractionScope iInteractionScope = this.scopes.removeFirst();
        iInteractionScope.verifyInteractions();
    }

    public synchronized Object create(String string, Class<?> clazz) {
        return this.factory.create(string, clazz, this);
    }

    private void throwAnyPreviousError() {
        if (!this.errors.isEmpty()) {
            throw this.errors.get(0);
        }
    }
}

