/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import java.util.List;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.IResultGenerator;
import org.spockframework.mock.TooManyInvocationsError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockInteraction
implements IMockInteraction {
    private final int line;
    private final int column;
    private final String text;
    private final int minCount;
    private final int maxCount;
    private final List<IInvocationConstraint> matchers;
    private final IResultGenerator resultGenerator;
    private int acceptedCount;

    public MockInteraction(int n, int n2, String string, int n3, int n4, List<IInvocationConstraint> list, IResultGenerator iResultGenerator) {
        this.line = n;
        this.column = n2;
        this.text = string;
        this.minCount = n3;
        this.maxCount = n4;
        this.matchers = list;
        this.resultGenerator = iResultGenerator;
    }

    @Override
    public boolean matches(IMockInvocation iMockInvocation) {
        for (IInvocationConstraint iInvocationConstraint : this.matchers) {
            if (iInvocationConstraint.isSatisfiedBy(iMockInvocation)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object accept(IMockInvocation iMockInvocation) {
        ++this.acceptedCount;
        if (this.acceptedCount > this.maxCount) {
            throw new TooManyInvocationsError(this, iMockInvocation);
        }
        return this.resultGenerator.generate(iMockInvocation);
    }

    @Override
    public boolean isSatisfied() {
        return this.acceptedCount >= this.minCount;
    }

    @Override
    public boolean isExhausted() {
        return this.acceptedCount >= this.maxCount;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String toString() {
        return String.format("%s   (%d %s)", this.text, this.acceptedCount, this.acceptedCount == 1 ? "invocation" : "invocations");
    }
}

