/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spockframework.mock.IArgumentConstraint;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedArgumentListConstraint
implements IInvocationConstraint {
    private final List<Object> argNames;
    private final List<IArgumentConstraint> argConstraints;

    public NamedArgumentListConstraint(List<Object> list, List<IArgumentConstraint> list2) {
        Assert.that(list.size() == list2.size());
        this.argNames = list;
        this.argConstraints = list2;
    }

    @Override
    public boolean isSatisfiedBy(IMockInvocation iMockInvocation) {
        List<Object> list = iMockInvocation.getArguments();
        if (list.size() == 1 && list.get(0) instanceof Map) {
            return this.matchesArgMap(new HashMap((Map)list.get(0)));
        }
        return this.matchesArgList(new ArrayList<Object>(list));
    }

    private boolean matchesArgList(List<Object> list) {
        for (int i = 0; i < this.argConstraints.size(); ++i) {
            Iterator<Object> iterator;
            block3: {
                Object object = this.argNames.get(i);
                if (!object.equals("_")) {
                    return false;
                }
                IArgumentConstraint iArgumentConstraint = this.argConstraints.get(i);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!iArgumentConstraint.isSatisfiedBy(iterator.next())) continue;
                    break block3;
                }
                return false;
            }
            iterator.remove();
        }
        return true;
    }

    private boolean matchesArgMap(Map map) {
        IArgumentConstraint iArgumentConstraint;
        Object object;
        int n;
        for (n = 0; n < this.argConstraints.size(); ++n) {
            object = this.argNames.get(n);
            if (object.equals("_")) continue;
            iArgumentConstraint = this.argConstraints.get(n);
            if (map.containsKey(object) && iArgumentConstraint.isSatisfiedBy(map.remove(object))) continue;
            return false;
        }
        block1: for (n = 0; n < this.argConstraints.size(); ++n) {
            object = this.argNames.get(n);
            if (!object.equals("_")) continue;
            iArgumentConstraint = this.argConstraints.get(n);
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                if (!iArgumentConstraint.isSatisfiedBy(iterator.next())) continue;
                iterator.remove();
                continue block1;
            }
            return false;
        }
        return true;
    }
}

