/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spockframework.mock.IArgumentConstraint;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.SpreadWildcardArgumentConstraint;
import org.spockframework.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionalArgumentListConstraint
implements IInvocationConstraint {
    private final List<IArgumentConstraint> argConstraints;

    public PositionalArgumentListConstraint(List<IArgumentConstraint> list) {
        this.argConstraints = list;
    }

    @Override
    public boolean isSatisfiedBy(IMockInvocation iMockInvocation) {
        List<Object> list = iMockInvocation.getArguments();
        if (this.areConstraintsSatisfiedBy(list)) {
            return true;
        }
        if (!this.canBeCalledWithVarArgSyntax(iMockInvocation.getMethod())) {
            return false;
        }
        return this.areConstraintsSatisfiedBy(this.expandVarArgs(list));
    }

    private boolean canBeCalledWithVarArgSyntax(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        return classArray.length > 0 && classArray[classArray.length - 1].isArray();
    }

    private List<Object> expandVarArgs(List<Object> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(list.subList(0, list.size() - 1));
        arrayList.addAll(Arrays.asList((Object[])CollectionUtil.getLastElement(list)));
        return arrayList;
    }

    private boolean areConstraintsSatisfiedBy(List<Object> list) {
        if (this.argConstraints.isEmpty()) {
            return list.isEmpty();
        }
        if (this.argConstraints.size() - list.size() > 1) {
            return false;
        }
        for (int i = 0; i < this.argConstraints.size() - 1; ++i) {
            if (this.argConstraints.get(i).isSatisfiedBy(list.get(i))) continue;
            return false;
        }
        IArgumentConstraint iArgumentConstraint = CollectionUtil.getLastElement(this.argConstraints);
        if (iArgumentConstraint instanceof SpreadWildcardArgumentConstraint) {
            return true;
        }
        return this.argConstraints.size() == list.size() && iArgumentConstraint.isSatisfiedBy(CollectionUtil.getLastElement(list));
    }
}

