/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import java.util.List;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.InteractionNotSatisfiedError;
import org.spockframework.mock.MockController;
import org.spockframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooFewInvocationsError
extends InteractionNotSatisfiedError {
    private final List<IMockInteraction> interactions;

    public TooFewInvocationsError(List<IMockInteraction> list) {
        Assert.notNull(list);
        Assert.that(list.size() > 0);
        this.interactions = list;
        this.fixupStackTrace();
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Too few invocations for:\n\n");
        for (IMockInteraction iMockInteraction : this.interactions) {
            stringBuilder.append(iMockInteraction);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private void fixupStackTrace() {
        StackTraceElement[] stackTraceElementArray = this.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (!this.isLeaveScopeCall(stackTraceElementArray[i])) continue;
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            stackTraceElementArray[i] = new StackTraceElement(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), this.interactions.get(0).getLine());
            this.setStackTrace(stackTraceElementArray);
            return;
        }
        Assert.fail("MockController.leaveScope() not found in stacktrace", new Object[0]);
    }

    private boolean isLeaveScopeCall(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName().equals(MockController.class.getName()) && stackTraceElement.getMethodName().equals("leaveScope");
    }
}

