/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.junit.runner.Description;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.RunStatus;
import org.spockframework.runtime.SafeIterationNameProvider;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.MethodInvocation;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.ReflectionUtil;

public class BaseSpecRunner {
    private static final Method DO_RUN_SPEC;
    private static final Method DO_RUN_FEATURE;
    private static final Method DO_RUN_ITERATION;
    protected static final Object[] EMPTY_ARGS;
    protected final SpecInfo spec;
    protected final IRunSupervisor supervisor;
    protected FeatureInfo currentFeature;
    protected IterationInfo currentIteration;
    protected Object sharedInstance;
    protected Object currentInstance;
    protected int runStatus = 0;

    public BaseSpecRunner(SpecInfo specInfo, IRunSupervisor iRunSupervisor) {
        this.spec = specInfo;
        this.supervisor = iRunSupervisor;
    }

    public int run() {
        if (this.spec.isExcluded() || this.spec.isSkipped()) {
            this.supervisor.specSkipped(this.spec);
            return 0;
        }
        this.createSpecInstance(true);
        this.invokeSharedInitializer();
        this.runSpec();
        return this.resetStatus(16);
    }

    private void runSpec() {
        if (this.runStatus != 0) {
            return;
        }
        this.supervisor.beforeSpec(this.spec);
        this.invoke(this, this.createMethodInfoForDoRunSpec(), new Object[0]);
        this.supervisor.afterSpec(this.spec);
    }

    private MethodInfo createMethodInfoForDoRunSpec() {
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setParent(this.spec);
        methodInfo.setKind(MethodKind.SPEC_EXECUTION);
        methodInfo.setReflection(DO_RUN_SPEC);
        methodInfo.setDescription(this.spec.getDescription());
        for (IMethodInterceptor iMethodInterceptor : this.spec.getInterceptors()) {
            methodInfo.addInterceptor(iMethodInterceptor);
        }
        return methodInfo;
    }

    public void doRunSpec() {
        this.invokeSetupSpec();
        this.runFeatures();
        this.invokeCleanupSpec();
    }

    private void createSpecInstance(boolean bl) {
        if (this.runStatus != 0) {
            return;
        }
        try {
            if (bl) {
                this.sharedInstance = ((Class)this.spec.getReflection()).newInstance();
                ((Field)this.spec.getSharedInstanceField().getReflection()).set(this.sharedInstance, this.sharedInstance);
            } else {
                this.currentInstance = ((Class)this.spec.getReflection()).newInstance();
                ((Field)this.spec.getSharedInstanceField().getReflection()).set(this.currentInstance, this.sharedInstance);
            }
        }
        catch (Throwable throwable) {
            throw new InternalSpockError("Failed to instantiate spec '%s'", throwable).withArgs(this.spec.getName());
        }
    }

    private void invokeSharedInitializer() {
        for (SpecInfo specInfo : this.spec.getSpecsTopToBottom()) {
            if (this.runStatus != 0) {
                return;
            }
            this.invoke(this.sharedInstance, specInfo.getSharedInitializerMethod(), new Object[0]);
        }
    }

    private void invokeSetupSpec() {
        for (SpecInfo specInfo : this.spec.getSpecsTopToBottom()) {
            if (this.runStatus != 0) {
                return;
            }
            this.invoke(this.sharedInstance, specInfo.getSetupSpecMethod(), new Object[0]);
        }
    }

    private void runFeatures() {
        for (FeatureInfo featureInfo : this.spec.getAllFeaturesInExecutionOrder()) {
            if (this.resetStatus(8) != 0) {
                return;
            }
            this.currentFeature = featureInfo;
            this.runFeature();
            this.currentFeature = null;
        }
    }

    private void invokeCleanupSpec() {
        for (SpecInfo specInfo : this.spec.getSpecsBottomToTop()) {
            if (RunStatus.action(this.runStatus) == 2) {
                return;
            }
            this.invoke(this.sharedInstance, specInfo.getCleanupSpecMethod(), new Object[0]);
        }
    }

    private void runFeature() {
        if (this.runStatus != 0) {
            return;
        }
        if (this.currentFeature.isExcluded()) {
            return;
        }
        if (this.currentFeature.isSkipped()) {
            this.supervisor.featureSkipped(this.currentFeature);
            return;
        }
        this.supervisor.beforeFeature(this.currentFeature);
        this.invoke(this, this.createMethodInfoForDoRunFeature(), new Object[0]);
        this.supervisor.afterFeature(this.currentFeature);
    }

    private MethodInfo createMethodInfoForDoRunFeature() {
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setParent(this.currentFeature.getParent());
        methodInfo.setKind(MethodKind.FEATURE_EXECUTION);
        methodInfo.setReflection(DO_RUN_FEATURE);
        methodInfo.setFeature(this.currentFeature);
        methodInfo.setDescription(this.currentFeature.getDescription());
        for (IMethodInterceptor iMethodInterceptor : this.currentFeature.getInterceptors()) {
            methodInfo.addInterceptor(iMethodInterceptor);
        }
        return methodInfo;
    }

    public void doRunFeature() {
        this.currentFeature.setIterationNameProvider(new SafeIterationNameProvider(this.currentFeature.getIterationNameProvider()));
        if (this.currentFeature.isParameterized()) {
            this.runParameterizedFeature();
        } else {
            this.runSimpleFeature();
        }
    }

    private void runSimpleFeature() {
        if (this.runStatus != 0) {
            return;
        }
        this.initializeAndRunIteration(EMPTY_ARGS, 1);
        this.resetStatus(4);
    }

    protected void initializeAndRunIteration(Object[] objectArray, int n) {
        if (this.runStatus != 0) {
            return;
        }
        this.createSpecInstance(false);
        this.invokeInitializer();
        this.runIteration(objectArray, n);
    }

    private void runIteration(Object[] objectArray, int n) {
        if (this.runStatus != 0) {
            return;
        }
        this.currentIteration = this.createIterationInfo(objectArray, n);
        this.supervisor.beforeIteration(this.currentIteration);
        this.invoke(this, this.createMethodInfoForDoRunIteration(), new Object[0]);
        this.supervisor.afterIteration(this.currentIteration);
        this.currentIteration = null;
    }

    private IterationInfo createIterationInfo(Object[] objectArray, int n) {
        this.currentIteration = new IterationInfo(this.currentFeature, objectArray, n);
        String string = this.currentFeature.getIterationNameProvider().getName(this.currentIteration);
        this.currentIteration.setName(string);
        this.currentIteration.setDescription(Description.createTestDescription((Class)((Class)this.spec.getReflection()), (String)string, (Annotation[])((Method)this.currentFeature.getFeatureMethod().getReflection()).getAnnotations()));
        return this.currentIteration;
    }

    private MethodInfo createMethodInfoForDoRunIteration() {
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setParent(this.currentFeature.getParent());
        methodInfo.setKind(MethodKind.ITERATION_EXECUTION);
        methodInfo.setReflection(DO_RUN_ITERATION);
        methodInfo.setFeature(this.currentFeature);
        methodInfo.setDescription(this.currentFeature.getDescription());
        for (IMethodInterceptor iMethodInterceptor : this.currentFeature.getIterationInterceptors()) {
            methodInfo.addInterceptor(iMethodInterceptor);
        }
        return methodInfo;
    }

    public void doRunIteration() {
        this.invokeSetup();
        this.invokeFeatureMethod();
        this.invokeCleanup();
    }

    protected int resetStatus(int n) {
        if (RunStatus.scope(this.runStatus) <= n) {
            this.runStatus = 0;
        }
        return this.runStatus;
    }

    protected void runParameterizedFeature() {
        throw new UnsupportedOperationException("This runner cannot run parameterized features");
    }

    private void invokeInitializer() {
        for (SpecInfo specInfo : this.spec.getSpecsTopToBottom()) {
            if (this.runStatus != 0) {
                return;
            }
            this.invoke(this.currentInstance, specInfo.getInitializerMethod(), new Object[0]);
        }
    }

    private void invokeSetup() {
        for (SpecInfo specInfo : this.spec.getSpecsTopToBottom()) {
            if (this.runStatus != 0) {
                return;
            }
            this.invoke(this.currentInstance, specInfo.getSetupMethod(), new Object[0]);
        }
    }

    private void invokeFeatureMethod() {
        if (this.runStatus != 0) {
            return;
        }
        this.invoke(this.currentInstance, this.currentFeature.getFeatureMethod(), this.currentIteration.getDataValues());
    }

    private void invokeCleanup() {
        for (SpecInfo specInfo : this.spec.getSpecsBottomToTop()) {
            if (RunStatus.action(this.runStatus) == 2) {
                return;
            }
            this.invoke(this.currentInstance, specInfo.getCleanupMethod(), new Object[0]);
        }
    }

    private void invoke(Object object, MethodInfo methodInfo, Object ... objectArray) {
        if (methodInfo.getInterceptors().isEmpty()) {
            this.invokeRaw(object, methodInfo, objectArray);
            return;
        }
        MethodInvocation methodInvocation = new MethodInvocation(this.currentFeature, this.currentIteration, this.sharedInstance, this.currentInstance, object, methodInfo, objectArray);
        try {
            methodInvocation.proceed();
        }
        catch (Throwable throwable) {
            ErrorInfo errorInfo = new ErrorInfo(methodInfo, throwable);
            this.runStatus = this.supervisor.error(errorInfo);
        }
    }

    protected Object invokeRaw(Object object, MethodInfo methodInfo, Object ... objectArray) {
        if (methodInfo.isStub()) {
            return null;
        }
        try {
            return ReflectionUtil.invokeMethod(object, (Method)methodInfo.getReflection(), objectArray);
        }
        catch (Throwable throwable) {
            this.runStatus = this.supervisor.error(new ErrorInfo(methodInfo, throwable));
            return null;
        }
    }

    static {
        EMPTY_ARGS = new Object[0];
        try {
            DO_RUN_SPEC = BaseSpecRunner.class.getMethod("doRunSpec", new Class[0]);
            DO_RUN_FEATURE = BaseSpecRunner.class.getMethod("doRunFeature", new Class[0]);
            DO_RUN_ITERATION = BaseSpecRunner.class.getMethod("doRunIteration", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalSpockError(noSuchMethodException);
        }
    }
}

