/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.regex.Pattern;
import org.spockframework.runtime.ExpressionInfoBuilder;
import org.spockframework.runtime.ExpressionInfoRenderer;
import org.spockframework.runtime.ExpressionInfoValueRenderer;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Condition {
    private static final Pattern pattern = Pattern.compile("\\s*\n\\s*");
    private final Iterable<Object> values;
    private final String text;
    private final TextPosition position;
    private final String message;
    private volatile ExpressionInfo expression;
    private volatile String rendering;

    public Condition(Iterable<Object> iterable, String string, TextPosition textPosition, String string2) {
        this.text = string;
        this.position = textPosition;
        this.values = iterable;
        this.message = string2;
    }

    public Iterable<Object> getValues() {
        return this.values;
    }

    public String getText() {
        return this.text;
    }

    public TextPosition getPosition() {
        return this.position;
    }

    public String getMessage() {
        return this.message;
    }

    public ExpressionInfo getExpression() {
        if (this.expression == null) {
            this.createExpression();
        }
        return this.expression;
    }

    public String getRendering() {
        if (this.rendering == null) {
            this.createRendering();
        }
        return this.rendering;
    }

    private void createExpression() {
        if (this.text == null || this.values == null) {
            return;
        }
        this.expression = new ExpressionInfoBuilder(this.flatten(this.text), TextPosition.create(1, 1), this.values).build();
    }

    private void createRendering() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getExpression() != null) {
            ExpressionInfoValueRenderer.render(this.expression);
            stringBuilder.append(ExpressionInfoRenderer.render(this.expression));
        } else if (this.text != null) {
            stringBuilder.append(this.flatten(this.text));
            stringBuilder.append("\n");
        } else {
            stringBuilder.append("(Source code not available)\n");
        }
        if (this.message != null) {
            stringBuilder.append("\n");
            stringBuilder.append(this.message);
            stringBuilder.append("\n");
        }
        this.rendering = stringBuilder.toString();
    }

    private String flatten(String string) {
        return pattern.matcher(string).replaceAll(" ");
    }
}

