/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.spockframework.builder.DelegatingScript;
import org.spockframework.util.GroovyRuntimeUtil;
import spock.config.ConfigurationException;

public class ConfigurationScriptLoader {
    private static final String DEFAULT_CONFIG_PROPERTY_KEY = "spock.configuration";
    private static final String DEFAULT_CLASS_PATH_LOCATION = "SpockConfig.groovy";
    private static final String DEFAULT_FILE_SYSTEM_LOCATION = System.getProperty("user.home") + File.separator + ".spock" + File.separator + "SpockConfig.groovy";
    private final String configPropertyKey;
    private final String classPathLocation;
    private final String fileSystemLocation;

    public ConfigurationScriptLoader() {
        this(DEFAULT_CONFIG_PROPERTY_KEY, DEFAULT_CLASS_PATH_LOCATION, DEFAULT_FILE_SYSTEM_LOCATION);
    }

    ConfigurationScriptLoader(String string, String string2, String string3) {
        this.configPropertyKey = string;
        this.classPathLocation = string2;
        this.fileSystemLocation = string3;
    }

    public DelegatingScript loadAutoDetectedScript() {
        DelegatingScript delegatingScript = this.loadScriptFromSystemPropertyInducedLocation(this.configPropertyKey);
        if (delegatingScript != null) {
            return delegatingScript;
        }
        delegatingScript = this.loadScriptFromClassPathLocation(this.classPathLocation);
        if (delegatingScript != null) {
            return delegatingScript;
        }
        delegatingScript = this.loadScriptFromFileSystemLocation(this.fileSystemLocation);
        if (delegatingScript != null) {
            return delegatingScript;
        }
        return null;
    }

    public DelegatingScript loadClosureBasedScript(final Closure closure) {
        return new DelegatingScript(){

            public Object run() {
                GroovyRuntimeUtil.invokeClosure(closure, new Object[0]);
                return null;
            }

            public void $setDelegate(Object object) {
                closure.setResolveStrategy(1);
                closure.setDelegate(object);
            }
        };
    }

    private DelegatingScript loadScriptFromSystemPropertyInducedLocation(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        DelegatingScript delegatingScript = this.loadScriptFromClassPathLocation(string2);
        if (delegatingScript != null) {
            return delegatingScript;
        }
        delegatingScript = this.loadScriptFromFileSystemLocation(string2);
        if (delegatingScript != null) {
            return delegatingScript;
        }
        throw new ConfigurationException("Cannot find configuration script '%s'", string2);
    }

    private DelegatingScript loadScriptFromFileSystemLocation(String string) {
        File file = new File(string);
        try {
            if (!file.exists()) {
                return null;
            }
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
        GroovyShell groovyShell = this.createShell();
        try {
            return (DelegatingScript)groovyShell.parse(file);
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Error reading configuration script '%s'", string);
        }
        catch (CompilationFailedException compilationFailedException) {
            throw new ConfigurationException("Error compiling configuration script '%s'", string);
        }
    }

    private DelegatingScript loadScriptFromClassPathLocation(String string) {
        URL uRL = this.getClass().getClassLoader().getResource(string);
        if (uRL == null) {
            return null;
        }
        GroovyShell groovyShell = this.createShell();
        try {
            return (DelegatingScript)groovyShell.parse(new GroovyCodeSource(uRL));
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Error reading configuration script '%s'", string);
        }
        catch (CompilationFailedException compilationFailedException) {
            throw new ConfigurationException("Error compiling configuration script '%s'", string);
        }
    }

    private GroovyShell createShell() {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setScriptBaseClass(DelegatingScript.class.getName());
        return new GroovyShell(this.getClass().getClassLoader(), new Binding(), compilerConfiguration);
    }
}

