/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Iterator;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.spockframework.runtime.ExpressionInfoConverter;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.runtime.model.TextRegion;
import org.spockframework.util.Assert;
import org.spockframework.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionInfoBuilder {
    private final String text;
    private final String adjustedText;
    private final TextPosition startPos;
    private final Iterable<Object> values;
    private final String[] lines;

    public ExpressionInfoBuilder(String string, TextPosition textPosition, Iterable<Object> iterable) {
        this.text = string;
        this.startPos = textPosition;
        this.values = iterable;
        this.adjustedText = TextUtil.repeatChar(' ', textPosition.getColumnIndex()) + string;
        this.lines = this.adjustedText.split("\n");
    }

    public ExpressionInfo build() {
        SourceUnit sourceUnit = SourceUnit.create((String)"Spec expression", (String)this.adjustedText);
        sourceUnit.parse();
        sourceUnit.completePhase();
        sourceUnit.convert();
        BlockStatement blockStatement = sourceUnit.getAST().getStatementBlock();
        Assert.that(blockStatement != null && blockStatement.getStatements().size() == 1);
        Statement statement = (Statement)blockStatement.getStatements().get(0);
        Assert.that(statement instanceof ExpressionStatement);
        Expression expression = ((ExpressionStatement)statement).getExpression();
        ExpressionInfo expressionInfo = (ExpressionInfo)new ExpressionInfoConverter(this.lines).convert(expression);
        Iterator<Object> iterator = this.values.iterator();
        for (ExpressionInfo expressionInfo2 : expressionInfo.inPostfixOrder(false)) {
            expressionInfo2.setText(this.findText(expressionInfo2.getRegion()));
            if (!iterator.hasNext()) {
                Assert.fail("Missing value for expression '%s' in condition '%s'", expressionInfo2.getText(), this.text);
            }
            expressionInfo2.setValue(iterator.next());
            if (this.startPos.getLineIndex() <= 0) continue;
            expressionInfo2.shiftVertically(this.startPos.getLineIndex());
        }
        return expressionInfo;
    }

    private String findText(TextRegion textRegion) {
        if (textRegion == TextRegion.NOT_AVAILABLE) {
            return ExpressionInfo.TEXT_NOT_AVAILABLE;
        }
        try {
            String string = "";
            for (int i = 0; i <= textRegion.getEnd().getLineIndex(); ++i) {
                String string2 = this.lines[i];
                if (i == textRegion.getEnd().getLineIndex()) {
                    string2 = string2.substring(0, textRegion.getEnd().getColumnIndex());
                }
                if (i == textRegion.getStart().getLineIndex()) {
                    string2 = string2.substring(textRegion.getStart().getColumnIndex());
                }
                string = string + string2;
                if (i == textRegion.getEnd().getLineIndex()) continue;
                string = string + '\n';
            }
            return string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return ExpressionInfo.TEXT_NOT_AVAILABLE;
        }
    }
}

