/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.RegexExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.runtime.model.TextRegion;
import org.spockframework.util.AbstractExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionInfoConverter
extends AbstractExpressionConverter<ExpressionInfo> {
    private final String[] lines;

    public ExpressionInfoConverter(String[] stringArray) {
        this.lines = stringArray;
    }

    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        TextPosition textPosition = TextPosition.startOf((ASTNode)methodCallExpression.getMethod());
        ArrayList<ExpressionInfo> arrayList = new ArrayList<ExpressionInfo>();
        if (!methodCallExpression.isImplicitThis()) {
            arrayList.add((ExpressionInfo)this.convert(methodCallExpression.getObjectExpression()));
        }
        arrayList.add((ExpressionInfo)this.convert(methodCallExpression.getMethod()));
        arrayList.add((ExpressionInfo)this.convert(methodCallExpression.getArguments()));
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)methodCallExpression), textPosition, methodCallExpression.getMethodAsString(), arrayList);
    }

    public void visitBytecodeExpression(BytecodeExpression bytecodeExpression) {
        this.unsupported();
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression staticMethodCallExpression) {
        this.unsupported();
    }

    public void visitConstructorCallExpression(ConstructorCallExpression constructorCallExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)constructorCallExpression), TextPosition.startOf((ASTNode)constructorCallExpression), "<init>", (ExpressionInfo)this.convert(constructorCallExpression.getArguments()));
    }

    public void visitArgumentlistExpression(ArgumentListExpression argumentListExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)argumentListExpression), TextPosition.startOf((ASTNode)argumentListExpression), null, this.convertAll(argumentListExpression.getExpressions())).setRelevant(false);
    }

    public void visitPropertyExpression(PropertyExpression propertyExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)propertyExpression), TextPosition.startOf((ASTNode)propertyExpression.getProperty()), propertyExpression.getPropertyAsString(), propertyExpression.isImplicitThis() ? Collections.emptyList() : Collections.singletonList(this.convert(propertyExpression.getObjectExpression())));
    }

    public void visitAttributeExpression(AttributeExpression attributeExpression) {
        this.visitPropertyExpression((PropertyExpression)attributeExpression);
    }

    public void visitFieldExpression(FieldExpression fieldExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)fieldExpression), TextPosition.startOf((ASTNode)fieldExpression), fieldExpression.getFieldName(), new ExpressionInfo[0]);
    }

    public void visitMethodPointerExpression(MethodPointerExpression methodPointerExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)methodPointerExpression), TextPosition.startOf((ASTNode)methodPointerExpression.getMethodName()), methodPointerExpression.getMethodName().getText(), (ExpressionInfo)this.convert(methodPointerExpression.getExpression()), (ExpressionInfo)this.convert(methodPointerExpression.getMethodName())).setRelevant(false);
    }

    public void visitVariableExpression(VariableExpression variableExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)variableExpression), TextPosition.startOf((ASTNode)variableExpression), variableExpression.getName(), new ExpressionInfo[0]).setRelevant(variableExpression != VariableExpression.THIS_EXPRESSION && variableExpression != VariableExpression.SUPER_EXPRESSION);
    }

    public void visitDeclarationExpression(DeclarationExpression declarationExpression) {
        this.unsupported();
    }

    public void visitRegexExpression(RegexExpression regexExpression) {
        this.unsupported();
    }

    public void visitConstantExpression(ConstantExpression constantExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)constantExpression), TextPosition.startOf((ASTNode)constantExpression), constantExpression.getConstantName(), new ExpressionInfo[0]).setRelevant(false);
    }

    public void visitClassExpression(ClassExpression classExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)classExpression), TextPosition.startOf((ASTNode)classExpression), null, new ExpressionInfo[0]).setRelevant(false);
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)binaryExpression), binaryExpression.getOperation().getType() == 30 ? this.startOf("[", (ASTNode)binaryExpression.getRightExpression()) : TextPosition.startOf(binaryExpression.getOperation()), binaryExpression.getOperation().getText(), (ExpressionInfo)this.convert(binaryExpression.getLeftExpression()), (ExpressionInfo)this.convert(binaryExpression.getRightExpression()));
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression unaryMinusExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)unaryMinusExpression), TextPosition.startOf((ASTNode)unaryMinusExpression), "-", (ExpressionInfo)this.convert(unaryMinusExpression.getExpression()));
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression unaryPlusExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)unaryPlusExpression), TextPosition.startOf((ASTNode)unaryPlusExpression), "+", (ExpressionInfo)this.convert(unaryPlusExpression.getExpression()));
    }

    public void visitNotExpression(NotExpression notExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)notExpression), TextPosition.startOf((ASTNode)notExpression), "!", (ExpressionInfo)this.convert(notExpression.getExpression()));
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression bitwiseNegationExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)bitwiseNegationExpression), TextPosition.startOf((ASTNode)bitwiseNegationExpression), "^", (ExpressionInfo)this.convert(bitwiseNegationExpression.getExpression()));
    }

    public void visitListExpression(ListExpression listExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)listExpression), TextPosition.startOf((ASTNode)listExpression), "[]", this.convertAll(listExpression.getExpressions())).setRelevant(false);
    }

    public void visitRangeExpression(RangeExpression rangeExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)rangeExpression), this.startOf("..", (ASTNode)rangeExpression.getTo()), "..", (ExpressionInfo)this.convert(rangeExpression.getFrom()), (ExpressionInfo)this.convert(rangeExpression.getTo())).setRelevant(false);
    }

    public void visitMapExpression(MapExpression mapExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)mapExpression), TextPosition.startOf((ASTNode)mapExpression), "[:]", this.convertAll(mapExpression.getMapEntryExpressions())).setRelevant(false);
    }

    public void visitMapEntryExpression(MapEntryExpression mapEntryExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)mapEntryExpression), this.startOf(":", (ASTNode)mapEntryExpression.getValueExpression()), null, (ExpressionInfo)this.convert(mapEntryExpression.getKeyExpression()), (ExpressionInfo)this.convert(mapEntryExpression.getValueExpression()));
    }

    public void visitGStringExpression(GStringExpression gStringExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)gStringExpression), TextPosition.startOf((ASTNode)gStringExpression), "\"\"", this.convertAll(gStringExpression.getValues())).setRelevant(false);
    }

    public void visitTernaryExpression(TernaryExpression ternaryExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)ternaryExpression), this.startOf("?", (ASTNode)ternaryExpression.getTrueExpression()), "?:", this.convertAll(Arrays.asList(ternaryExpression.getBooleanExpression(), ternaryExpression.getTrueExpression(), ternaryExpression.getFalseExpression()))).setRelevant(false);
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression elvisOperatorExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)elvisOperatorExpression), this.startOf("?", (ASTNode)elvisOperatorExpression.getFalseExpression()), "?:", (ExpressionInfo)this.convert(elvisOperatorExpression.getTrueExpression()), (ExpressionInfo)this.convert(elvisOperatorExpression.getFalseExpression())).setRelevant(false);
    }

    public void visitPrefixExpression(PrefixExpression prefixExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)prefixExpression), TextPosition.startOf((ASTNode)prefixExpression), prefixExpression.getOperation().getText(), (ExpressionInfo)this.convert(prefixExpression.getExpression()));
    }

    public void visitPostfixExpression(PostfixExpression postfixExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)postfixExpression), TextPosition.startOf((ASTNode)postfixExpression), postfixExpression.getOperation().getText(), (ExpressionInfo)this.convert(postfixExpression.getExpression()));
    }

    public void visitBooleanExpression(BooleanExpression booleanExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)booleanExpression), TextPosition.startOf((ASTNode)booleanExpression), null, (ExpressionInfo)this.convert(booleanExpression.getExpression())).setRelevant(false);
    }

    public void visitClosureExpression(ClosureExpression closureExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)closureExpression), TextPosition.startOf((ASTNode)closureExpression), "{->}", new ExpressionInfo[0]).setRelevant(false);
    }

    public void visitTupleExpression(TupleExpression tupleExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)tupleExpression), TextPosition.startOf((ASTNode)tupleExpression), null, this.convertAll(tupleExpression.getExpressions())).setRelevant(false);
    }

    public void visitCastExpression(CastExpression castExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)castExpression), TextPosition.startOf((ASTNode)castExpression), "as", (ExpressionInfo)this.convert(castExpression.getExpression())).setRelevant(false);
    }

    public void visitClosureListExpression(ClosureListExpression closureListExpression) {
        this.unsupported();
    }

    public void visitArrayExpression(ArrayExpression arrayExpression) {
        List<ExpressionInfo> list = this.convertAll(arrayExpression.getExpressions());
        list.addAll(this.convertAll(arrayExpression.getSizeExpression()));
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)arrayExpression), TextPosition.startOf((ASTNode)arrayExpression), null, list).setRelevant(false);
    }

    public void visitSpreadExpression(SpreadExpression spreadExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)spreadExpression), TextPosition.startOf((ASTNode)spreadExpression), "*", (ExpressionInfo)this.convert(spreadExpression.getExpression())).setRelevant(false);
    }

    public void visitSpreadMapExpression(SpreadMapExpression spreadMapExpression) {
        this.result = new ExpressionInfo(TextRegion.of((ASTNode)spreadMapExpression), TextPosition.startOf((ASTNode)spreadMapExpression), "*:", new ExpressionInfo[0]);
    }

    private TextPosition startOf(String string, ASTNode aSTNode) {
        int n;
        for (int i = n = Math.max(aSTNode.getLineNumber(), aSTNode.getLastLineNumber()) - 1; i >= 0; --i) {
            int n2;
            int n3 = n2 = i == n ? this.lines[i].lastIndexOf(string, aSTNode.getColumnNumber() - 1) : this.lines[i].lastIndexOf(string);
            if (n2 == -1) continue;
            return TextPosition.create(i + 1, n2 + 1);
        }
        throw new IllegalArgumentException(String.format("token %s not found in expression", string));
    }
}

