/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;

public class ExpressionInfoRenderer {
    private final ExpressionInfo expr;
    private final List<StringBuilder> lines = new ArrayList<StringBuilder>();
    private final List<Integer> startColumns = new ArrayList<Integer>();

    private ExpressionInfoRenderer(ExpressionInfo expressionInfo) {
        TextPosition textPosition = expressionInfo.getRegion().getStart();
        if (textPosition.getLine() != 1 || textPosition.getColumn() != 1) {
            throw new IllegalArgumentException("can only print expressions starting at 1,1");
        }
        if (expressionInfo.getRegion().getEnd().getLine() != 1) {
            throw new IllegalArgumentException("can only print expressions ending on line 1");
        }
        this.expr = expressionInfo;
    }

    public static String render(ExpressionInfo expressionInfo) {
        return new ExpressionInfoRenderer(expressionInfo).render();
    }

    private String render() {
        this.placeText();
        this.placeValues();
        return this.linesToString();
    }

    private void placeText() {
        this.lines.add(new StringBuilder(this.expr.getText()));
        this.startColumns.add(0);
    }

    private void placeValues() {
        Comparator<ExpressionInfo> comparator = new Comparator<ExpressionInfo>(){

            @Override
            public int compare(ExpressionInfo expressionInfo, ExpressionInfo expressionInfo2) {
                return expressionInfo2.getAnchor().getColumn() - expressionInfo.getAnchor().getColumn();
            }
        };
        for (ExpressionInfo expressionInfo : this.expr.inCustomOrder(true, comparator)) {
            this.placeValue(expressionInfo);
        }
    }

    private void placeValue(ExpressionInfo expressionInfo) {
        int n;
        String string = expressionInfo.getRenderedValue();
        if (string == null) {
            return;
        }
        int n2 = expressionInfo.getAnchor().getColumn();
        if (n2 < 1) {
            return;
        }
        String[] stringArray = string.split("\r\n|\r|\n");
        int n3 = n = stringArray.length == 1 ? expressionInfo.getAnchor().getColumn() + string.length() : Integer.MAX_VALUE;
        if (this.lines.size() == 1) {
            this.lines.add(new StringBuilder());
            this.startColumns.add(0);
        }
        for (int i = 1; i < this.lines.size(); ++i) {
            if (n < this.startColumns.get(i)) {
                ExpressionInfoRenderer.placeString(this.lines.get(i), string, n2);
                this.startColumns.set(i, n2);
                return;
            }
            ExpressionInfoRenderer.placeString(this.lines.get(i), "|", n2);
            if (i <= 1) continue;
            this.startColumns.set(i, n2 + 1);
        }
        for (String string2 : stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            this.lines.add(stringBuilder);
            ExpressionInfoRenderer.placeString(stringBuilder, string2, n2);
            this.startColumns.add(n2);
        }
    }

    private String linesToString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (StringBuilder stringBuilder2 : this.lines) {
            stringBuilder.append((CharSequence)stringBuilder2).append('\n');
        }
        return stringBuilder.toString();
    }

    private static void placeString(StringBuilder stringBuilder, String string, int n) {
        while (stringBuilder.length() < n) {
            stringBuilder.append(' ');
        }
        stringBuilder.replace(n - 1, n - 1 + string.length(), string);
    }
}

