/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import groovy.lang.GString;
import org.spockframework.runtime.condition.EditDistance;
import org.spockframework.runtime.condition.EditPathRenderer;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.util.GroovyRuntimeUtil;
import org.spockframework.util.ObjectUtil;

public class ExpressionInfoValueRenderer {
    private final ExpressionInfo expr;

    private ExpressionInfoValueRenderer(ExpressionInfo expressionInfo) {
        this.expr = expressionInfo;
    }

    public static void render(ExpressionInfo expressionInfo) {
        new ExpressionInfoValueRenderer(expressionInfo).render();
    }

    private void render() {
        for (ExpressionInfo expressionInfo : this.expr.inPostfixOrder(true)) {
            expressionInfo.setRenderedValue(this.renderValue(expressionInfo));
        }
    }

    private String renderValue(ExpressionInfo expressionInfo) {
        int n;
        String string;
        String string2;
        String string3;
        Object object = expressionInfo.getValue();
        if (object == null) {
            return "null";
        }
        if ("".equals(object)) {
            return "\"\"";
        }
        try {
            string3 = this.doRenderValue(expressionInfo);
        }
        catch (Exception exception) {
            return String.format("%s (renderer threw %s)", this.javaLangObjectToString(object), exception.getClass().getSimpleName());
        }
        if (string3 == null || string3.equals("")) {
            return this.javaLangObjectToString(object);
        }
        if (object instanceof Enum && string3.equals(string2 = (string = expressionInfo.getText().trim()).substring((n = string.lastIndexOf(46)) + 1))) {
            return null;
        }
        return string3;
    }

    private String javaLangObjectToString(Object object) {
        String string = Integer.toHexString(System.identityHashCode(object));
        return object.getClass().getName() + "@" + string;
    }

    private String doRenderValue(ExpressionInfo expressionInfo) {
        String string = this.renderAsStringComparison(expressionInfo);
        if (string != null) {
            return string;
        }
        string = this.renderAsEqualityComparison(expressionInfo);
        if (string != null) {
            return string;
        }
        return GroovyRuntimeUtil.toString(expressionInfo.getValue());
    }

    private String renderAsStringComparison(ExpressionInfo expressionInfo) {
        if (!expressionInfo.isEqualityComparison(String.class, GString.class)) {
            return null;
        }
        String string = expressionInfo.getChildren().get(0).getValue().toString();
        String string2 = expressionInfo.getChildren().get(1).getValue().toString();
        EditDistance editDistance = new EditDistance(string, string2);
        return String.format("false\n%d difference%s (%d%% similarity)\n%s", editDistance.getDistance(), editDistance.getDistance() == 1 ? "" : "s", editDistance.getSimilarityInPercent(), new EditPathRenderer().render(string, string2, editDistance.calculatePath()));
    }

    private String renderAsEqualityComparison(ExpressionInfo expressionInfo) {
        if (!expressionInfo.isEqualityComparison()) {
            return null;
        }
        ExpressionInfo expressionInfo2 = expressionInfo.getChildren().get(0);
        ExpressionInfo expressionInfo3 = expressionInfo.getChildren().get(1);
        if (expressionInfo2.getEffectiveRenderedValue().equals(expressionInfo3.getEffectiveRenderedValue())) {
            this.addTypeHint(expressionInfo2);
            this.addTypeHint(expressionInfo3);
        }
        return "false";
    }

    private void addTypeHint(ExpressionInfo expressionInfo) {
        if (expressionInfo.getRenderedValue() == null) {
            return;
        }
        Class<?> clazz = ObjectUtil.voidAwareGetClass(expressionInfo.getValue());
        expressionInfo.setRenderedValue(expressionInfo.getRenderedValue() + " (" + clazz.getName() + ")");
    }
}

