/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionClassesLoader {
    public static final String EXTENSION_DESCRIPTOR_PATH = "META-INF/services/" + IGlobalExtension.class.getName();

    public List<Class<?>> loadClassesFromDefaultLocation() {
        return this.loadClasses(EXTENSION_DESCRIPTOR_PATH);
    }

    public List<Class<?>> loadClasses(String string) {
        ArrayList arrayList = new ArrayList();
        for (URL uRL : this.locateDescriptors(string)) {
            for (String string2 : this.readDescriptor(uRL)) {
                arrayList.add(this.loadExtensionClass(string2));
            }
        }
        return arrayList;
    }

    private List<URL> locateDescriptors(String string) {
        try {
            return Collections.list(RunContext.class.getClassLoader().getResources(string));
        }
        catch (Exception exception) {
            throw new ExtensionException("Failed to locate extension descriptors", exception);
        }
    }

    private List<String> readDescriptor(URL uRL) {
        ArrayList<String> arrayList;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string = bufferedReader.readLine();
            while (string != null) {
                if ((string = string.trim()).length() > 0 && !string.startsWith("#")) {
                    arrayList2.add(string);
                }
                string = bufferedReader.readLine();
            }
            arrayList = arrayList2;
        }
        catch (IOException iOException) {
            try {
                throw new ExtensionException("Failed to read extension descriptor '%s'", iOException).withArgs(uRL);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(bufferedReader);
        return arrayList;
    }

    private Class<?> loadExtensionClass(String string) {
        try {
            return RunContext.class.getClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            throw new ExtensionException("Failed to load extension class '%s'", exception).withArgs(string);
        }
    }
}

