/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.util.UnreachableCodeError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionRegistry {
    private final List<Class<?>> extensionClasses;
    private final List<Object> configurations;
    private final List<IGlobalExtension> extensions = new ArrayList<IGlobalExtension>();

    ExtensionRegistry(List<Class<?>> list, List<Object> list2) {
        this.extensionClasses = list;
        this.configurations = list2;
    }

    public void loadExtensions() {
        for (Class<?> clazz : this.extensionClasses) {
            this.extensions.add(this.configureExtension(this.instantiateExtension(this.verifyExtensionClass(clazz))));
        }
    }

    public List<IGlobalExtension> getExtensions() {
        return this.extensions;
    }

    private Class<?> verifyExtensionClass(Class<?> clazz) {
        if (!IGlobalExtension.class.isAssignableFrom(clazz)) {
            throw new ExtensionException("Class '%s' is not a valid global extension because it is not derived from '%s'").withArgs(clazz.getName(), IGlobalExtension.class.getName());
        }
        return clazz;
    }

    private IGlobalExtension instantiateExtension(Class<?> clazz) {
        try {
            return (IGlobalExtension)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ExtensionException("Failed to instantiate extension '%s'", exception).withArgs(clazz.getName());
        }
    }

    private IGlobalExtension configureExtension(IGlobalExtension iGlobalExtension) {
        for (Field field : iGlobalExtension.getClass().getDeclaredFields()) {
            if (!field.getType().getSimpleName().endsWith("Configuration")) continue;
            this.injectConfiguration(field, iGlobalExtension);
        }
        return iGlobalExtension;
    }

    private void injectConfiguration(Field field, Object object) {
        Object object2 = this.getOrCreateConfiguration(field.getType());
        field.setAccessible(true);
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnreachableCodeError();
        }
    }

    private Object getOrCreateConfiguration(Class<?> clazz) {
        for (Object object : this.configurations) {
            if (object.getClass() != clazz) continue;
            return object;
        }
        Object object = this.createConfiguration(clazz);
        this.configurations.add(object);
        return object;
    }

    private Object createConfiguration(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ExtensionException("Cannot instantiate configuration class %s").withArgs(clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExtensionException("Configuration class '%s' has no public no-arg constructor").withArgs(clazz);
        }
    }
}

